/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.executor.ProJdbcExecutor;
import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.SqlPlusRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class OracleSqlPlusExecutor
extends AbstractNativeToolExecutor {
    public OracleSqlPlusExecutor() {
        super("sqlplus");
    }

    public String getName() {
        return "sqlplus";
    }

    public int getPriority() {
        return 101;
    }

    public void execute(SqlStatement action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Executing with the '" + this.getName() + "' executor");
        Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(action, this.database);
        try {
            SqlPlusRunner runner = new SqlPlusRunner(this.changeSet, null, true);
            runner.addArg("-v");
            runner.executeCommand(this.database);
            log.info("Successfully validated 'sqlplus'");
            runner = new SqlPlusRunner(this.changeSet, sqls, false);
            runner.executeCommand(this.database);
            ProJdbcExecutor.showOracleSqlErrors(this.concatenateSqlStrings(sqls), this.database);
            String successMessage = String.format("%nSuccess!  Changeset '%s' by '%s' deployed by 'sqlplus'", this.changeSet.getId(), this.changeSet.getAuthor());
            log.info(successMessage);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            String errorMessage = String.format("%nChangeset '%s' by '%s' failed to deploy with 'sqlplus'. Please check sqlplus logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            log.info(errorMessage);
            log.info(e.getMessage());
            ProJdbcExecutor.showOracleSqlErrors(this.concatenateSqlStrings(sqls), this.database);
            throw new DatabaseException((Throwable)e);
        }
    }

    private String concatenateSqlStrings(Sql[] sqlStrings) {
        StringBuilder builder = new StringBuilder();
        for (Sql sql : sqlStrings) {
            String line = sql.toSql();
            line = line.replace("\r", "");
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }
}

