/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools.jcl;

import com.datical.liquibase.ext.tools.jcl.JclJobInfo;
import com.datical.liquibase.ext.tools.jcl.JclJobWorker;
import java.sql.CallableStatement;
import java.sql.Connection;
import lombok.Generated;

public class JclJob
implements AutoCloseable {
    public static final String COMPLETION_TYPE = "COMPLETION_TYPE";
    public static final String SYSTEM_ABENDCD = "SYSTEM_ABENDCD";
    public static final String USER_ABENDCD = "USER_ABENDCD";
    public static final String MAXRC = "MAXRC";
    public static final String STATUS = "STATUS";
    public static final String RETURN_CODE = "RETURN_CODE";
    public static final String MSG = "MSG";
    public static final int JOB_NOT_FOUND = 4;
    public static final int ERROR_RETRIEVING_JOB_STATUS = 12;
    private final Connection connection;
    private String id;
    private String jobName;
    public static final int PROCESSING_OPTION_CANCEL = 1;
    public static final int PROCESSING_OPTION_PURGE = 2;

    public JclJob(JclJobWorker jobWorker, String id, String jobName) {
        this.connection = jobWorker.getConnection();
        this.id = id;
        this.jobName = jobName;
    }

    public void cancel(String userID, String password, int processingOption) throws Exception {
        try (CallableStatement callStatement = this.connection.prepareCall("CALL SYSPROC.ADMIN_JOB_CANCEL (?, ?, ?, ?, ?, ?)");){
            callStatement.setString(1, userID);
            callStatement.setString(2, password);
            callStatement.setInt(3, processingOption);
            callStatement.setString(4, this.id);
            callStatement.registerOutParameter(5, 4);
            callStatement.registerOutParameter(6, 12);
            callStatement.execute();
            int returnCode = callStatement.getInt(RETURN_CODE);
            String message = callStatement.getString(MSG);
            if (returnCode != 0) {
                throw new Exception(message);
            }
        }
    }

    public void cancel(int processingOption) throws Exception {
        this.cancel(null, null, processingOption);
    }

    public void cancel(String userID, String password) throws Exception {
        this.cancel(userID, password, 1);
    }

    public void cancel() throws Exception {
        this.cancel(null, null);
    }

    public JclJobInfo retrieveInfo(String username, String password) throws Exception {
        try (CallableStatement callStatement = this.connection.prepareCall("CALL SYSPROC.ADMIN_JOB_QUERY (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            callStatement.setString(1, username);
            callStatement.setString(2, password);
            callStatement.setString(3, this.id);
            callStatement.registerOutParameter(4, 4);
            callStatement.registerOutParameter(5, 4);
            callStatement.registerOutParameter(6, 4);
            callStatement.registerOutParameter(7, 4);
            callStatement.registerOutParameter(8, 4);
            callStatement.registerOutParameter(9, 4);
            callStatement.registerOutParameter(10, 12);
            callStatement.execute();
            int returnCode = callStatement.getInt(RETURN_CODE);
            String message = callStatement.getString(MSG);
            if (returnCode == 4) {
                throw new Exception("The job was not found, or the job status is unknown.");
            }
            if (returnCode == 12) {
                throw new Exception(message);
            }
            int status = callStatement.getInt(4);
            int maxRC = callStatement.getInt(5);
            int completionType = callStatement.getInt(COMPLETION_TYPE);
            int systemAbendCode = callStatement.getInt(SYSTEM_ABENDCD);
            int userAbendCode = callStatement.getInt(USER_ABENDCD);
            JclJobInfo jclJobInfo = new JclJobInfo(status, maxRC, completionType, systemAbendCode, userAbendCode);
            return jclJobInfo;
        }
    }

    public void waitUntilFinished(long milliseconds, String username, String password) throws Exception {
        block3: {
            while (true) {
                JclJobInfo jobInfo;
                int jobStatus;
                if ((jobStatus = (jobInfo = this.retrieveInfo(username, password)).getStatus()) == 1 || jobStatus == 2) {
                    Thread.sleep(milliseconds);
                    continue;
                }
                if (jobStatus == 3) break block3;
                if (jobStatus == 4) {
                    throw new Exception("Job not found.");
                }
                if (jobStatus == 5) break;
            }
            throw new Exception("Job in an unknown phase.");
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }
}

