/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.java.truelicense.core.io.Sink;

public class Sinks {
    public static Sink output() {
        return Sinks.uncloseable(System.out);
    }

    public static Sink error() {
        return Sinks.uncloseable(System.err);
    }

    public static Sink uncloseable(final OutputStream outputStream) {
        return new Sink(){

            @Override
            public OutputStream output() {
                return new FilterOutputStream(outputStream){

                    @Override
                    public void close() throws IOException {
                        this.out.flush();
                    }
                };
            }
        };
    }

    private Sinks() {
    }
}

