/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.change.EnableCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableCheckConstraintGenerator
extends AbstractSqlGenerator<EnableCheckConstraintStatement> {
    @Override
    public boolean supports(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database;
    }

    @Override
    public ValidationErrors validate(EnableCheckConstraintStatement enableCheckConstraintStatement, Database object, SqlGeneratorChain sqlGeneratorChain) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("tableName", enableCheckConstraintStatement.getTableName());
        ((ValidationErrors)object).checkRequiredField("constraintName", enableCheckConstraintStatement.getConstraintName());
        return object;
    }

    @Override
    public Sql[] generateSql(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database, SqlGeneratorChain object) {
        object = new StringBuilder();
        ((StringBuilder)object).append("ALTER TABLE ");
        String string = database.escapeTableName(enableCheckConstraintStatement.getCatalogName(), enableCheckConstraintStatement.getSchemaName(), enableCheckConstraintStatement.getTableName());
        ((StringBuilder)object).append(string);
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object).append(" ENABLE CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        } else if (database instanceof AbstractDb2Database) {
            ((StringBuilder)object).append(" ALTER CHECK ").append(enableCheckConstraintStatement.getConstraintName()).append(" ENFORCED");
        } else {
            ((StringBuilder)object).append(" WITH CHECK CHECK CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        }
        return new Sql[]{new UnparsedSql(((StringBuilder)object).toString(), new DatabaseObject[0])};
    }
}

