/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.Contexts;
import liquibase.change.CheckSum;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.GetNextChangeSetSequenceValueStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.RemoveChangeSetRanStatusStatement;
import liquibase.statement.core.SelectFromDatabaseChangeLogStatement;
import liquibase.statement.core.SetNullableStatement;
import liquibase.statement.core.TagDatabaseStatement;
import liquibase.statement.core.UpdateChangeSetChecksumStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class StandardChangeLogHistoryService
extends AbstractChangeLogHistoryService {
    private List<RanChangeSet> ranChangeSetList;
    private Integer lastChangeSetSequenceValue;

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    public String getDatabaseChangeLogTableName() {
        return this.getDatabase().getDatabaseChangeLogTableName();
    }

    public String getLiquibaseSchemaName() {
        return this.getDatabase().getLiquibaseSchemaName();
    }

    public String getLiquibaseCatalogName() {
        return this.getDatabase().getLiquibaseCatalogName();
    }

    public boolean canCreateChangeLogTable() throws DatabaseException {
        return true;
    }

    @Override
    public void reset() {
        this.ranChangeSetList = null;
    }

    public boolean hasDatabaseChangeLogTable() throws DatabaseException {
        if (this.ranChangeSetList != null) {
            return true;
        }
        try {
            return SnapshotGeneratorFactory.getInstance().hasDatabaseChangeLogTable(this.getDatabase());
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    @Override
    public void init() throws DatabaseException {
        Database database = this.getDatabase();
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        Table changeLogTable = null;
        try {
            changeLogTable = SnapshotGeneratorFactory.getInstance().getDatabaseChangeLogTable(new SnapshotControl(database, Table.class, Column.class), database);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        ArrayList<AbstractSqlStatement> statementsToExecute = new ArrayList<AbstractSqlStatement>();
        boolean changeLogCreateAttempted = false;
        if (changeLogTable != null) {
            String md5sum;
            List<Map<String, ?>> md5sumRS;
            boolean hasExecTypeColumn;
            boolean hasDescription = changeLogTable.getColumn("DESCRIPTION") != null;
            boolean bl = changeLogTable.getColumn("COMMENTS") != null;
            boolean hasTag = changeLogTable.getColumn("TAG") != null;
            boolean hasLiquibase = changeLogTable.getColumn("LIQUIBASE") != null;
            boolean liquibaseColumnNotRightSize = false;
            if (!(this.getDatabase() instanceof SQLiteDatabase)) {
                Integer columnSize = changeLogTable.getColumn("LIQUIBASE").getType().getColumnSize();
                liquibaseColumnNotRightSize = columnSize != null && columnSize != 20;
            }
            boolean hasOrderExecuted = changeLogTable.getColumn("ORDEREXECUTED") != null;
            boolean checksumNotRightSize = false;
            if (!this.getDatabase().getConnection().getDatabaseProductName().equals("SQLite")) {
                Integer columnSize = changeLogTable.getColumn("MD5SUM").getType().getColumnSize();
                checksumNotRightSize = columnSize != null && columnSize != 35;
            }
            boolean bl2 = hasExecTypeColumn = changeLogTable.getColumn("EXECTYPE") != null;
            if (!hasDescription) {
                executor.comment("Adding missing databasechangelog.description column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasTag) {
                executor.comment("Adding missing databasechangelog.tag column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!bl) {
                executor.comment("Adding missing databasechangelog.comments column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasLiquibase) {
                executor.comment("Adding missing databasechangelog.liquibase column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
            }
            if (!hasOrderExecuted) {
                executor.comment("Adding missing databasechangelog.orderexecuted column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("ORDEREXECUTED", -1));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "ORDEREXECUTED", "INT", false));
            }
            if (checksumNotRightSize) {
                executor.comment("Modifying size of databasechangelog.md5sum column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "MD5SUM", "VARCHAR(35)"));
            }
            if (liquibaseColumnNotRightSize) {
                executor.comment("Modifying size of databasechangelog.liquibase column");
                statementsToExecute.add(new ModifyDataTypeStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(20)"));
            }
            if (!hasExecTypeColumn) {
                executor.comment("Adding missing databasechangelog.exectype column");
                statementsToExecute.add(new AddColumnStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", null, new ColumnConstraint[0]));
                statementsToExecute.add(new UpdateStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()).addNewColumnValue("EXECTYPE", "EXECUTED"));
                statementsToExecute.add(new SetNullableStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), "EXECTYPE", "VARCHAR(10)", false));
            }
            if ((md5sumRS = ExecutorService.getInstance().getExecutor(database).queryForList(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByNotNullCheckSum(), "MD5SUM"))).size() > 0 && !(md5sum = md5sumRS.get(0).get("MD5SUM").toString()).startsWith(CheckSum.getCurrentVersion() + ":")) {
                executor.comment("DatabaseChangeLog checksums are an incompatible version.  Setting them to null so they will be updated on next database update");
                statementsToExecute.add(new RawSqlStatement("UPDATE " + this.getDatabase().escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " SET MD5SUM=null"));
            }
        } else if (!changeLogCreateAttempted) {
            executor.comment("Create Database Change Log Table");
            CreateDatabaseChangeLogTableStatement createTableStatement = new CreateDatabaseChangeLogTableStatement();
            if (!this.canCreateChangeLogTable()) {
                throw new DatabaseException("Cannot create " + this.getDatabase().escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()) + " table for your getDatabase().\n\n" + "Please construct it manually using the following SQL as a base and re-run Liquibase:\n\n" + createTableStatement);
            }
            statementsToExecute.add(createTableStatement);
            LogFactory.getLogger().info("Creating database history table with name: " + this.getDatabase().escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName()));
        }
        for (SqlStatement sqlStatement : statementsToExecute) {
            if (SqlGeneratorFactory.getInstance().supports(sqlStatement, database)) {
                executor.execute(sqlStatement);
                this.getDatabase().commit();
                continue;
            }
            LogFactory.getLogger().info("Cannot run " + sqlStatement.getClass().getSimpleName() + " on " + this.getDatabase().getShortName() + " when checking databasechangelog table");
        }
    }

    @Override
    public void upgradeChecksums(DatabaseChangeLog databaseChangeLog, Contexts contexts) throws DatabaseException {
        super.upgradeChecksums(databaseChangeLog, contexts);
        this.getDatabase().commit();
    }

    @Override
    public List<RanChangeSet> getRanChangeSets() throws DatabaseException {
        if (this.ranChangeSetList == null) {
            Database database = this.getDatabase();
            String databaseChangeLogTableName = this.getDatabase().escapeTableName(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName());
            ArrayList<RanChangeSet> ranChangeSetList = new ArrayList<RanChangeSet>();
            if (this.hasDatabaseChangeLogTable()) {
                LogFactory.getLogger().info("Reading from " + databaseChangeLogTableName);
                List<Map<String, ?>> results = this.queryDatabaseChangeLogTable(database);
                for (Map<String, ?> rs : results) {
                    String fileName = rs.get("FILENAME").toString();
                    String author = rs.get("AUTHOR").toString();
                    String id = rs.get("ID").toString();
                    String md5sum = rs.get("MD5SUM") == null ? null : rs.get("MD5SUM").toString();
                    String description = rs.get("DESCRIPTION") == null ? null : rs.get("DESCRIPTION").toString();
                    String comments = rs.get("COMMENTS") == null ? null : rs.get("COMMENTS").toString();
                    Object tmpDateExecuted = rs.get("DATEEXECUTED");
                    Date dateExecuted = null;
                    if (tmpDateExecuted instanceof Date) {
                        dateExecuted = (Date)tmpDateExecuted;
                    } else {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            dateExecuted = df.parse((String)tmpDateExecuted);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    String tag = rs.get("TAG") == null ? null : rs.get("TAG").toString();
                    String execType = rs.get("EXECTYPE") == null ? null : rs.get("EXECTYPE").toString();
                    try {
                        RanChangeSet ranChangeSet = new RanChangeSet(fileName, id, author, CheckSum.parse(md5sum), dateExecuted, tag, ChangeSet.ExecType.valueOf(execType), description, comments);
                        ranChangeSetList.add(ranChangeSet);
                    }
                    catch (IllegalArgumentException e) {
                        LogFactory.getLogger().severe("Unknown EXECTYPE from database: " + execType);
                        throw e;
                    }
                }
            }
            this.ranChangeSetList = ranChangeSetList;
        }
        return Collections.unmodifiableList(this.ranChangeSetList);
    }

    public List<Map<String, ?>> queryDatabaseChangeLogTable(Database database) throws DatabaseException {
        SelectFromDatabaseChangeLogStatement select = new SelectFromDatabaseChangeLogStatement("FILENAME", "AUTHOR", "ID", "MD5SUM", "DATEEXECUTED", "ORDEREXECUTED", "EXECTYPE", "DESCRIPTION", "COMMENTS", "TAG", "LIQUIBASE").setOrderBy("DATEEXECUTED ASC", "ORDEREXECUTED ASC");
        return ExecutorService.getInstance().getExecutor(database).queryForList(select);
    }

    @Override
    protected void replaceChecksum(ChangeSet changeSet) throws DatabaseException {
        ExecutorService.getInstance().getExecutor(this.getDatabase()).execute(new UpdateChangeSetChecksumStatement(changeSet));
        this.getDatabase().commit();
        this.reset();
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws DatabaseException, DatabaseHistoryException {
        if (!this.hasDatabaseChangeLogTable()) {
            return null;
        }
        return super.getRanChangeSet(changeSet);
    }

    @Override
    public void setExecType(ChangeSet changeSet, ChangeSet.ExecType execType) throws DatabaseException {
        Database database = this.getDatabase();
        ExecutorService.getInstance().getExecutor(database).execute(new MarkChangeSetRanStatement(changeSet, execType));
        this.getDatabase().commit();
        this.ranChangeSetList.add(new RanChangeSet(changeSet, execType));
    }

    @Override
    public void removeFromHistory(ChangeSet changeSet) throws DatabaseException {
        Database database = this.getDatabase();
        ExecutorService.getInstance().getExecutor(database).execute(new RemoveChangeSetRanStatusStatement(changeSet));
        this.getDatabase().commit();
        this.ranChangeSetList.remove(new RanChangeSet(changeSet));
    }

    @Override
    public int getNextSequenceValue() throws LiquibaseException {
        if (this.lastChangeSetSequenceValue == null) {
            this.lastChangeSetSequenceValue = this.getDatabase().getConnection() == null ? Integer.valueOf(0) : Integer.valueOf(ExecutorService.getInstance().getExecutor(this.getDatabase()).queryForInt(new GetNextChangeSetSequenceValueStatement()));
        }
        this.lastChangeSetSequenceValue = this.lastChangeSetSequenceValue + 1;
        return this.lastChangeSetSequenceValue;
    }

    @Override
    public void tag(String tagString) throws DatabaseException {
        Database database = this.getDatabase();
        Executor executor = ExecutorService.getInstance().getExecutor(database);
        try {
            int totalRows = ExecutorService.getInstance().getExecutor(database).queryForInt(new SelectFromDatabaseChangeLogStatement("COUNT(*)"));
            if (totalRows == 0) {
                ChangeSet emptyChangeSet = new ChangeSet(String.valueOf(new Date().getTime()), "liquibase", false, false, "liquibase-internal", null, null, this.getDatabase().getObjectQuotingStrategy(), null);
                this.setExecType(emptyChangeSet, ChangeSet.ExecType.EXECUTED);
            }
            executor.execute(new TagDatabaseStatement(tagString));
            this.getDatabase().commit();
            this.ranChangeSetList.get(this.ranChangeSetList.size() - 1).setTag(tagString);
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public boolean tagExists(String tag) throws DatabaseException {
        int count = ExecutorService.getInstance().getExecutor(this.getDatabase()).queryForInt(new SelectFromDatabaseChangeLogStatement(new SelectFromDatabaseChangeLogStatement.ByTag(tag), "COUNT(*)"));
        return count > 0;
    }

    @Override
    public void clearAllCheckSums() throws LiquibaseException {
        Database database = this.getDatabase();
        UpdateStatement updateStatement = new UpdateStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName());
        updateStatement.addNewColumnValue("MD5SUM", null);
        ExecutorService.getInstance().getExecutor(database).execute(updateStatement);
        database.commit();
    }

    @Override
    public void destroy() throws DatabaseException {
        Database database = this.getDatabase();
        try {
            if (SnapshotGeneratorFactory.getInstance().has(new Table().setName(database.getDatabaseChangeLogTableName()).setSchema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName()), database)) {
                ExecutorService.getInstance().getExecutor(database).execute(new DropTableStatement(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName(), false));
            }
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

