/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;
import liquibase.util.SystemUtils;

public abstract class AbstractResourceAccessor
implements ResourceAccessor {
    private Set<String> rootStrings = new HashSet<String>();

    protected void init() {
        Enumeration<URL> baseUrls;
        try {
            baseUrls = this.toClassLoader().getResources("");
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        while (baseUrls.hasMoreElements()) {
            this.rootStrings.add(baseUrls.nextElement().toExternalForm());
        }
    }

    protected boolean isCaseSensitive() {
        return !SystemUtils.isWindows();
    }

    protected Set<String> getRootPaths() {
        return this.rootStrings;
    }

    protected void getContents(File rootFile, boolean recursive, boolean includeFiles, boolean includeDirectories, String basePath, Set<String> returnSet) {
        File[] files = rootFile.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                if (includeDirectories) {
                    returnSet.add(this.convertToPath(file.getAbsolutePath()));
                }
                if (!recursive) continue;
                this.getContents(file, recursive, includeFiles, includeDirectories, basePath, returnSet);
                continue;
            }
            if (!includeFiles) continue;
            returnSet.add(this.convertToPath(file.getAbsolutePath()));
        }
    }

    protected String convertToPath(String string) {
        String stringAsUrl = string = string.replace("\\", "/");
        if (!stringAsUrl.matches("[a-zA-Z0-9]{2,}:.*")) {
            stringAsUrl = stringAsUrl.startsWith("/") ? "file:" + stringAsUrl : "file:/" + stringAsUrl;
        }
        for (String rootString : this.getRootPaths()) {
            boolean matches = false;
            matches = this.isCaseSensitive() ? stringAsUrl.startsWith(rootString) : stringAsUrl.toLowerCase().startsWith(rootString.toLowerCase());
            if (!matches) continue;
            string = stringAsUrl.substring(rootString.length());
            break;
        }
        string = string.replaceFirst("^//", "/");
        while (string.matches(".*[^:]//.*")) {
            string = string.replaceAll("([^:])//", "$1/");
        }
        while (string.contains("/./")) {
            string = string.replace("/./", "/");
        }
        while (string.matches(".*/.*?/\\.\\./.*")) {
            string = string.replaceAll("/[^/]+/\\.\\./", "/");
        }
        return string;
    }

    protected String convertToPath(String relativeTo, String path) {
        if (StringUtils.trimToNull(relativeTo) == null) {
            return path;
        }
        URL baseUrl = this.toClassLoader().getResource(relativeTo);
        if (baseUrl == null) {
            throw new UnexpectedLiquibaseException("Cannot find base path '" + relativeTo + "'");
        }
        if (baseUrl.toExternalForm().startsWith("file:")) {
            File baseFile = new File(baseUrl.getPath());
            if (!baseFile.exists()) {
                throw new UnexpectedLiquibaseException("Base file '" + baseFile.getAbsolutePath() + "' does not exist");
            }
            if (baseFile.isFile()) {
                baseFile = baseFile.getParentFile();
            }
            return this.convertToPath(baseFile.toURI().getPath() + "/" + path);
        }
        return this.convertToPath(relativeTo + "/" + path);
    }
}

