/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommand$1;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DetermineNumberChangesFollowingVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;

public class RollbackOneUpdateCommand
extends AbstractSelfConfiguratingCommand {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private Database database;
    private String deploymentId;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Writer outputWriter;
    private Liquibase liquibase;
    private Boolean force;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private boolean ignoreClasspathPrefix;
    private String rollbackScript;
    private ResourceAccessor resourceAccessor;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;
    private Logger log = LogService.getLog(this.getClass());

    @Override
    public String getName() {
        return "rollbackOneUpdate";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void configure(Map object) {
        if (object.containsKey("help")) {
            if (object.containsKey("outputWriter")) {
                System.out.println("liquibase <global parameters> rollbackOneUpdateSQL [--deploymentId=<id>]\n\nrollbackOneUpdateSQL         Displays the SQL which will be executed when the corresponding rollbackOneUpdate command is executed, and does not\n                             perform the actual rollback.  (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            } else {
                System.out.println("liquibase <global parameters> rollbackOneUpdate [--deploymentId=id] --force\n\nrollbackOneUpdate            Rolls back all the changesets from one update, identified by \"deploymentId\", if all the changesets\n                             can be rolled back. If not, a WARNING message will provide details.  (Liquibase Pro key required)\n                             Note:  A list of deployment IDs may be viewed by using the \"history\" coammand.\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --force                  is required to make sure you intended to run this operation\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            }
            System.exit(0);
        }
        this.deploymentId = (String)object.get("deploymentId");
        this.database = (Database)object.get("database");
        this.changeLog = (DatabaseChangeLog)object.get("changeLog");
        this.resourceAccessor = (ResourceAccessor)object.get("resourceAccessor");
        this.changeLogParameters = (ChangeLogParameters)object.get("changeLogParameters");
        this.force = (Boolean)object.get("force");
        if (this.force == null || !this.force.booleanValue()) {
            RollbackOneUpdateCommand rollbackOneUpdateCommand = this;
            object = rollbackOneUpdateCommand.createMessageForMissingForceOption(rollbackOneUpdateCommand.database);
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.liquibase = (Liquibase)object.get("liquibase");
        this.outputWriter = (Writer)object.get("outputWriter");
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new RollbackOneUpdateCommand$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    @Override
    protected CommandResult run() {
        Object object;
        Map.Entry<String, ChangeSet> entry2;
        Executor executor = null;
        if (this.outputWriter != null) {
            executor = ExecutorService.getInstance().getExecutor(this.database);
            ExecutorService.getInstance().setExecutor(this.database, new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), this.outputWriter, this.database));
        }
        Iterator<Map.Entry<String, ChangeSet>> iterator = this.database.getRanChangeSetList();
        if (this.deploymentId == null) {
            this.deploymentId = this.getLastDeploymentId((List<RanChangeSet>)((Object)iterator));
            if (this.deploymentId == null) {
                throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
            }
            LogService.getLog(this.getClass()).info(LogType.USER_MESSAGE, "Defaulting to last deployment ID '" + this.deploymentId + "'");
        } else {
            boolean bl2 = false;
            entry2 = iterator.iterator();
            while (entry2.hasNext()) {
                object = entry2.next();
                if (!this.deploymentId.equals(((RanChangeSet)object).getDeploymentId())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                entry2 = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), this.deploymentId);
                throw new LiquibaseException("\n".concat(String.valueOf(entry2)));
            }
        }
        this.liquibase.outputHeader("Rollback deployment ID '" + this.deploymentId + "'");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            this.changeLog.setIgnoreClasspathPrefix(false);
            entry2 = new DeploymentIdFilter(this.deploymentId, this.database, (List<RanChangeSet>)((Object)iterator), this.changeLog);
            if (!((DeploymentIdFilter)((Object)entry2)).getNoInverseChangeSets().isEmpty()) {
                object = "\n\nThere are change sets associated with the deployment ID '" + this.deploymentId + "' which cannot be rolled back.\nNo rollback was performed.\n";
                object = (String)object + "\nChange Sets which cannot be rolled back:\n";
                for (Map.Entry<String, ChangeSet> entry2 : ((DeploymentIdFilter)((Object)entry2)).getNoInverseChangeSets().entrySet()) {
                    object = (String)object + entry2.getKey();
                    object = (String)object + "\n";
                }
                throw new LiquibaseException("\n".concat(String.valueOf(object)));
            }
            if (((DeploymentIdFilter)((Object)entry2)).isEmpty()) {
                object = "\n\nThere are no change sets associated with the deployment ID '" + this.deploymentId + "'.\nPlease check your parameters.  No rollback was performed.\n";
                throw new LiquibaseException("\n".concat(String.valueOf(object)));
            }
            this.createChangeLogIterator((List<RanChangeSet>)((Object)iterator), (ChangeSetFilter)((Object)entry2)).run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
        }
        catch (RollbackFailedException rollbackFailedException) {
            entry2 = rollbackFailedException;
            object = rollbackFailedException.getCause();
            if (object != null && object instanceof RollbackImpossibleException) {
                iterator = "\nError executing rollback:\nThe rollback for deployment ID '" + this.deploymentId + "' has at least one change set without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
                LogService.getLog(this.getClass()).severe(LogType.LOG, (String)((Object)iterator), (Throwable)((Object)entry2));
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)((Object)entry2));
                }
                throw new LiquibaseException((String)((Object)iterator), (Throwable)((Object)entry2));
            }
            LogService.getLog(this.getClass()).severe(LogType.LOG, "\nError executing rollback for the deployment ID '" + this.deploymentId + "'.");
            if (this.changeExecListener != null) {
                this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)((Object)entry2));
            }
            throw new LiquibaseException("\nError executing rollback for the deployment ID '" + this.deploymentId + "':\n" + ((Throwable)((Object)entry2)).getMessage(), (Throwable)((Object)entry2));
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                this.log.severe(LogType.LOG, MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (executor != null) {
                ExecutorService.getInstance().setExecutor(this.database, executor);
            }
        }
        this.resetServices();
        return new CommandResult("rollbackOneChangeSet executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getLastDeploymentId(List<RanChangeSet> object) {
        if (object == null || object.size() == 0) {
            return null;
        }
        List<RanChangeSet> list = object;
        object = list.get(list.size() - 1).getDeploymentId();
        if (object == null) {
            return null;
        }
        return object;
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list, this.ignoreClasspathPrefix), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        ExecutorService.getInstance().reset();
    }

    private String createMessageForMissingForceOption(Database object) {
        object = object.getRanChangeSetList();
        object = new ChangeLogIterator((List<RanChangeSet>)object, this.changeLog, new AlreadyRanChangeSetFilter((List<RanChangeSet>)object, false));
        Object object2 = new DetermineNumberChangesFollowingVisitor(this.changeSetId, this.changeSetAuthor, this.changeSetPath);
        ((ChangeLogIterator)object).run((ChangeSetVisitor)object2, new RuntimeEnvironment(null, null, null));
        object = coreBundle.getString("force.option.required");
        object2 = new Integer(((DetermineNumberChangesFollowingVisitor)object2).getNumChangeSetsFollowing());
        object = String.format((String)object, object2, "rollbackOneUpdateSQL");
        if ((Integer)object2 == 1) {
            object = ((String)object).replaceAll("is followed by 1 changesets", "is followed by 1 changeset");
        }
        return object;
    }
}

