/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import liquibase.configuration.ConfigurationContainer;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.SystemPropertyProvider;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.StringUtil;

public class LiquibaseConfiguration {
    private Map<Class, ConfigurationContainer> configurations;
    private ConfigurationValueProvider[] configurationValueProviders;
    private static LiquibaseConfiguration instance;

    public static synchronized LiquibaseConfiguration getInstance() {
        if (instance == null) {
            instance = new LiquibaseConfiguration();
            instance.init(new SystemPropertyProvider());
        }
        return instance;
    }

    public static synchronized void setInstance(LiquibaseConfiguration instance) {
        LiquibaseConfiguration.instance = instance;
    }

    protected LiquibaseConfiguration() {
    }

    public void init(ConfigurationValueProvider ... configurationValueProviders) {
        if (configurationValueProviders == null) {
            configurationValueProviders = new ConfigurationValueProvider[]{};
        }
        this.configurationValueProviders = configurationValueProviders;
        this.reset();
    }

    public void reset() {
        this.configurations = new HashMap<Class, ConfigurationContainer>();
    }

    public <T extends ConfigurationContainer> T getConfiguration(Class<T> type) {
        if (!this.configurations.containsKey(type)) {
            this.configurations.put(type, (ConfigurationContainer)this.createConfiguration(type));
        }
        return (T)this.configurations.get(type);
    }

    public ConfigurationContainer getConfiguration(String typeName) {
        for (Map.Entry<Class, ConfigurationContainer> entry : this.configurations.entrySet()) {
            if (!entry.getKey().getName().equals(typeName)) continue;
            return entry.getValue();
        }
        try {
            Class<?> typeClass = Class.forName(typeName);
            this.configurations.put(typeClass, (ConfigurationContainer)this.createConfiguration(typeClass));
            return this.configurations.get(typeClass);
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public ConfigurationProperty getProperty(Class<? extends ConfigurationContainer> type, String property) {
        ConfigurationContainer configuration = this.getConfiguration(type);
        return configuration.getProperty(property);
    }

    protected <T extends ConfigurationContainer> T createConfiguration(Class<T> type) {
        try {
            ConfigurationContainer configuration = (ConfigurationContainer)type.getConstructor(new Class[0]).newInstance(new Object[0]);
            configuration.init(this.configurationValueProviders);
            return (T)configuration;
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException("Cannot create default configuration " + type.getName(), e2);
        }
    }

    public String describeValueLookupLogic(Class<? extends ConfigurationContainer> config, String property) {
        return this.describeValueLookupLogic(this.getProperty(config, property));
    }

    public String describeValueLookupLogic(ConfigurationProperty property) {
        ArrayList<String> reasons = new ArrayList<String>();
        for (ConfigurationValueProvider container : this.configurationValueProviders) {
            reasons.add(container.describeValueLookupLogic(property));
        }
        return StringUtil.join(reasons, " AND ");
    }

    public boolean shouldIncludeCatalogInSpecification() {
        Boolean includeCatalog = this.getConfiguration(GlobalConfiguration.class).getValue("includeCatalogInSpecification", Boolean.class);
        return includeCatalog != null ? includeCatalog : false;
    }
}

