/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.statement.core.CreateProcedureStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class CreateFunctionGenerator
extends AbstractSqlGenerator<CreateFunctionStatement> {
    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public ValidationErrors validate(CreateFunctionStatement createFunctionStatement, Database database, SqlGeneratorChain object) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("functionName", createFunctionStatement.getFunctionName());
        ((ValidationErrors)object).checkRequiredField("functionBody", createFunctionStatement.getFunctionBody());
        ((ValidationErrors)object).checkDisallowedField("catalogName", createFunctionStatement.getCatalogName(), database, MSSQLDatabase.class);
        return object;
    }

    @Override
    public Sql[] generateSql(CreateFunctionStatement createFunctionStatement, Database database, SqlGeneratorChain object) {
        String string;
        object = ";";
        if (database instanceof OracleDatabase) {
            object = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            object = "";
        }
        Object object2 = createFunctionStatement.getSchemaName();
        if (object2 == null && database instanceof PostgresDatabase) {
            object2 = database.getDefaultSchemaName();
        }
        object2 = CreateProcedureGenerator.addSchemaToText(CreateProcedureGenerator.removeTrailingDelimiter(createFunctionStatement.getFunctionBody(), (String)object), (String)object2, "FUNCTION", database);
        ArrayList<Sql> arrayList = new ArrayList<Sql>();
        if (createFunctionStatement.getReplaceIfExists() != null && createFunctionStatement.getReplaceIfExists().booleanValue()) {
            string = createFunctionStatement.getFunctionName();
            string = createFunctionStatement.getSchemaName() == null ? "dbo.".concat(String.valueOf(string)) : createFunctionStatement.getSchemaName() + "." + string;
            StringClauses stringClauses = SqlParser.parse((String)object2, true, true);
            object2 = SqlParser.parse((String)object2, true, true);
            StringClauses.ClauseIterator clauseIterator = stringClauses.getClauseIterator();
            StringClauses.ClauseIterator clauseIterator2 = ((StringClauses)object2).getClauseIterator();
            Object object3 = "START";
            while (object3 != null && !object3.toString().equalsIgnoreCase("create") && !object3.toString().equalsIgnoreCase("alter") && clauseIterator.hasNext()) {
                object3 = clauseIterator.nextNonWhitespace();
                clauseIterator2.nextNonWhitespace();
            }
            clauseIterator.replace("CREATE");
            clauseIterator2.replace("ALTER");
            object2 = "if object_id('" + string + "') is null exec ('" + stringClauses.toString().replace("'", "''") + "') else exec ('" + ((StringClauses)object2).toString().replace("'", "''") + "')";
        }
        if (database instanceof PostgresDatabase && (string = this.generateSchemaSetSql(createFunctionStatement, database)) != null) {
            arrayList.add(new UnparsedSql(string, (String)object, new DatabaseObject[0]));
        }
        arrayList.add(new UnparsedSql((String)object2, (String)object, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(arrayList, createFunctionStatement.getSchemaName(), database);
        ArrayList<Sql> arrayList2 = arrayList;
        return arrayList2.toArray(new Sql[arrayList2.size()]);
    }

    private String generateSchemaSetSql(CreateFunctionStatement object, Database object2) {
        if ((object = ((CreateProcedureStatement)object).getSchemaName()) == null || ((String)object).isEmpty()) {
            object = object2.getDefaultSchemaName();
        }
        if (object == null) {
            return null;
        }
        if (PostgresDatabase.DbTypes.EDB.equals(object2 = ((PostgresDatabase)object2).getDbType())) {
            return String.format("ALTER SESSION SET SEARCH_PATH=%s\n", object);
        }
        return String.format("SET SEARCH_PATH=%s\n", object);
    }
}

