/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import liquibase.Scope;
import liquibase.command.CommandResult;
import liquibase.command.core.DiffCommand;
import liquibase.command.core.SnapshotCommand;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.util.StringUtil;

public class DiffToChangeLogCommand
extends DiffCommand {
    private String changeLogFile;
    private PrintStream outputStream;
    private DiffOutputControl diffOutputControl;

    @Override
    public String getName() {
        return "diffChangeLog";
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public DiffToChangeLogCommand setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
        return this;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public DiffToChangeLogCommand setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public DiffOutputControl getDiffOutputControl() {
        return this.diffOutputControl;
    }

    public DiffToChangeLogCommand setDiffOutputControl(DiffOutputControl diffOutputControl) {
        this.diffOutputControl = diffOutputControl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandResult run() throws Exception {
        SnapshotCommand.logUnsupportedDatabase(this.getReferenceDatabase(), this.getClass());
        DiffResult diffResult = this.createDiffResult();
        PrintStream outputStream = this.getOutputStream();
        if (outputStream == null) {
            outputStream = System.out;
        }
        this.outputBestPracticeMessage();
        ObjectQuotingStrategy originalStrategy = this.getReferenceDatabase().getObjectQuotingStrategy();
        try {
            this.getReferenceDatabase().setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            if (StringUtil.trimToNull(this.changeLogFile) == null) {
                this.createDiffToChangeLogObject(diffResult).print(outputStream);
            } else {
                this.createDiffToChangeLogObject(diffResult).print(this.changeLogFile);
            }
        }
        finally {
            this.getReferenceDatabase().setObjectQuotingStrategy(originalStrategy);
        }
        return new CommandResult("OK");
    }

    protected DiffToChangeLog createDiffToChangeLogObject(DiffResult diffResult) {
        return new DiffToChangeLog(diffResult, this.diffOutputControl);
    }

    protected void outputBestPracticeMessage() {
        Scope.getCurrentScope().getUI().sendMessage("BEST PRACTICE: The changelog generated by diffChangeLog/generateChangeLog should be inspected for correctness and completeness before being deployed");
    }
}

