/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.Map;
import java.util.Properties;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.util.StringUtil;

public class SystemPropertyProvider
implements ConfigurationValueProvider {
    @Override
    public Object getValue(String namespace, String property) {
        String propValue = System.getProperty(namespace + "." + property);
        if (StringUtil.isNotEmpty(propValue)) {
            return propValue;
        }
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.equalsIgnoreCase(namespace + "." + property)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String describeValueLookupLogic(ConfigurationProperty property) {
        return "System property '" + property.getNamespace() + "." + property.getName() + "'";
    }
}

