/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.listener;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.AbstractChangeExecListener;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Operation;
import liquibase.hub.model.OperationChangeEvent;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.ChangeLogSerializerFactory;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

public class HubChangeExecListener
extends AbstractChangeExecListener
implements ChangeExecListener,
ChangeLogSyncListener {
    private static final Logger logger = Scope.getCurrentScope().getLog(HubChangeExecListener.class);
    private final Operation operation;
    private final Map<ChangeSet, Date> startDateMap = new HashMap<ChangeSet, Date>();
    private String rollbackScriptContents;
    private int postCount;
    private int failedToPostCount;

    public HubChangeExecListener(Operation operation) {
        this.operation = operation;
    }

    public void setRollbackScriptContents(String rollbackScriptContents) {
        this.rollbackScriptContents = rollbackScriptContents;
    }

    public int getPostCount() {
        return this.postCount;
    }

    public int getFailedToPostCount() {
        return this.failedToPostCount;
    }

    @Override
    public void willRun(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.RunStatus runStatus) {
        this.startDateMap.put(changeSet, new Date());
    }

    @Override
    public void willRun(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
    }

    @Override
    public void ran(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, ChangeSet.ExecType execType) {
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHub(changeSet, databaseChangeLog, database, "UPDATE", "PASS", message);
    }

    @Override
    public void willRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
    }

    @Override
    public void rollbackFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception e2) {
        this.updateHubForRollback(changeSet, databaseChangeLog, database, "FAIL", e2.getMessage());
    }

    @Override
    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHubForRollback(changeSet, databaseChangeLog, database, "PASS", message);
    }

    @Override
    public void preconditionFailed(PreconditionFailedException error, PreconditionContainer.FailOption onFail) {
    }

    @Override
    public void preconditionErrored(PreconditionErrorException error, PreconditionContainer.ErrorOption onError) {
    }

    @Override
    public void ran(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
    }

    @Override
    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        this.updateHub(changeSet, databaseChangeLog, database, "UPDATE", "FAIL", exception.getMessage());
    }

    @Override
    public void markedRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        this.startDateMap.put(changeSet, new Date());
        String message = "PASSED::" + changeSet.getId() + "::" + changeSet.getAuthor();
        this.updateHub(changeSet, databaseChangeLog, database, "SYNC", "PASS", message);
    }

    private void updateHubForRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, String operationStatusType, String statusMessage) {
        HubChangeLog hubChangeLog;
        if (this.operation == null) {
            boolean hubOn;
            HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
            String apiKey = StringUtil.trimToNull(hubConfiguration.getLiquibaseHubApiKey());
            boolean bl2 = hubOn = !LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class).getLiquibaseHubMode().equalsIgnoreCase("off");
            if (apiKey != null && hubOn) {
                String message = "Hub communication failure.\nThe data for operation on changeset '" + changeSet.getId() + "' by author '" + changeSet.getAuthor() + "'\nwas not successfully recorded in your Liquibase Hub project";
                Scope.getCurrentScope().getUI().sendMessage(message);
                logger.info(message);
            }
            return;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        try {
            hubChangeLog = hubService.getHubChangeLog(UUID.fromString(databaseChangeLog.getChangeLogId()));
            if (hubChangeLog == null) {
                logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
                return;
            }
        }
        catch (LiquibaseHubException lhe) {
            logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
            return;
        }
        Date dateExecuted = new Date();
        OperationChangeEvent operationChangeEvent = new OperationChangeEvent();
        operationChangeEvent.setEventType("ROLLBACK");
        operationChangeEvent.setStartDate(this.startDateMap.get(changeSet));
        operationChangeEvent.setEndDate(dateExecuted);
        operationChangeEvent.setDateExecuted(dateExecuted);
        operationChangeEvent.setChangesetId(changeSet.getId());
        operationChangeEvent.setChangesetFilename(changeSet.getFilePath());
        operationChangeEvent.setChangesetAuthor(changeSet.getAuthor());
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            SqlStatement[] statements;
            List<Change> changes;
            if (this.rollbackScriptContents != null) {
                sqlList.add(this.rollbackScriptContents);
            } else if (changeSet.hasCustomRollbackChanges()) {
                changes = changeSet.getRollback().getChanges();
                for (Change change : changes) {
                    for (SqlStatement statement : statements = change.generateStatements(database)) {
                        for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                            sqlList.add(sql.toSql());
                        }
                    }
                }
            } else {
                changes = changeSet.getChanges();
                for (Change change : changes) {
                    for (SqlStatement statement : statements = change.generateRollbackStatements(database)) {
                        for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(statement, database)) {
                            sqlList.add(sql.toSql());
                        }
                    }
                }
            }
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage());
        }
        String[] sqlArray = new String[sqlList.size()];
        sqlArray = sqlList.toArray(sqlArray);
        operationChangeEvent.setGeneratedSql(sqlArray);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer(".json");
        try {
            serializer.write(Collections.singletonList(changeSet), baos);
            operationChangeEvent.setChangesetBody(baos.toString("UTF-8"));
        }
        catch (IOException statements) {
            // empty catch block
        }
        operationChangeEvent.setOperationStatusType(operationStatusType);
        operationChangeEvent.setStatusMessage(statusMessage);
        if ("FAIL".equals(operationStatusType)) {
            operationChangeEvent.setLogs(statusMessage);
        } else {
            String logs = this.getCurrentLog();
            if (!StringUtil.isEmpty(logs)) {
                operationChangeEvent.setLogs(logs);
            } else {
                operationChangeEvent.setLogs(statusMessage);
            }
        }
        operationChangeEvent.setLogsTimestamp(new Date());
        operationChangeEvent.setProject(hubChangeLog.getProject());
        operationChangeEvent.setOperation(this.operation);
        try {
            hubService.sendOperationChangeEvent(operationChangeEvent);
            ++this.postCount;
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage(), lbe);
            logger.warning("Unable to send Operation Change Event for operation '" + this.operation.getId().toString() + " change set '" + changeSet.toString(false));
        }
    }

    private String getCurrentLog() {
        BufferedLogService bufferedLogService = (BufferedLogService)((Object)Scope.getCurrentScope().get(BufferedLogService.class.getName(), BufferedLogService.class));
        if (bufferedLogService != null) {
            return bufferedLogService.getLogAsString(Level.INFO);
        }
        return null;
    }

    private void updateHub(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, String eventType, String operationStatusType, String statusMessage) {
        String[] sqlArray;
        HubChangeLog hubChangeLog;
        if (this.operation == null) {
            boolean hubOn;
            HubConfiguration hubConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
            String apiKey = StringUtil.trimToNull(hubConfiguration.getLiquibaseHubApiKey());
            boolean bl2 = hubOn = !LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class).getLiquibaseHubMode().equalsIgnoreCase("off");
            if (apiKey != null && hubOn) {
                String message = databaseChangeLog.getChangeLogId() == null ? "The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub.\nThe data for operation on changeset '" + changeSet.getId() + "' by author '" + changeSet.getAuthor() + "'\nwas not successfully recorded in your Liquibase Hub project." : "Hub communication failure.\nThe data for operation on changeset '" + changeSet.getId() + "' by author '" + changeSet.getAuthor() + "'\nwas not successfully recorded in your Liquibase Hub project.";
                Scope.getCurrentScope().getUI().sendMessage(message);
                logger.info(message);
            }
            return;
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        try {
            hubChangeLog = hubService.getHubChangeLog(UUID.fromString(databaseChangeLog.getChangeLogId()));
            if (hubChangeLog == null) {
                logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
                return;
            }
        }
        catch (LiquibaseHubException lhe) {
            logger.warning("The changelog '" + databaseChangeLog.getPhysicalFilePath() + "' has not been registered with Hub");
            return;
        }
        OperationChangeEvent operationChangeEvent = new OperationChangeEvent();
        ArrayList<String> sqlList = new ArrayList<String>();
        if (!eventType.equals("SYNC")) {
            List<Change> changes = changeSet.getChanges();
            for (Change change : changes) {
                Sql[] sqls;
                for (Sql sql : sqls = SqlGeneratorFactory.getInstance().generateSql(change, database)) {
                    sqlList.add(sql.toSql());
                }
            }
            sqlArray = new String[sqlList.size()];
            sqlArray = sqlList.toArray(sqlArray);
            operationChangeEvent.setGeneratedSql(sqlArray);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ChangeLogSerializer serializer = ChangeLogSerializerFactory.getInstance().getSerializer(".json");
            try {
                serializer.write(Collections.singletonList(changeSet), baos);
                operationChangeEvent.setChangesetBody(baos.toString("UTF-8"));
            }
            catch (IOException ioe) {
                logger.warning("Unable to serialize change set '" + changeSet.toString(false) + "' for Hub.");
            }
        }
        Date dateExecuted = new Date();
        sqlArray = new String[sqlList.size()];
        sqlArray = sqlList.toArray(sqlArray);
        operationChangeEvent.setEventType(eventType);
        operationChangeEvent.setStartDate(this.startDateMap.get(changeSet));
        operationChangeEvent.setEndDate(dateExecuted);
        operationChangeEvent.setDateExecuted(dateExecuted);
        operationChangeEvent.setChangesetId(changeSet.getId());
        operationChangeEvent.setChangesetFilename(changeSet.getFilePath());
        operationChangeEvent.setChangesetAuthor(changeSet.getAuthor());
        operationChangeEvent.setOperationStatusType(operationStatusType);
        operationChangeEvent.setStatusMessage(statusMessage);
        operationChangeEvent.setGeneratedSql(sqlArray);
        operationChangeEvent.setOperation(this.operation);
        operationChangeEvent.setLogsTimestamp(new Date());
        if ("FAIL".equals(operationStatusType)) {
            operationChangeEvent.setLogs(statusMessage);
        } else {
            String logs = this.getCurrentLog();
            if (!StringUtil.isEmpty(logs)) {
                operationChangeEvent.setLogs(logs);
            } else {
                operationChangeEvent.setLogs(statusMessage);
            }
        }
        operationChangeEvent.setProject(hubChangeLog.getProject());
        operationChangeEvent.setOperation(this.operation);
        try {
            hubService.sendOperationChangeEvent(operationChangeEvent);
            ++this.postCount;
        }
        catch (LiquibaseException lbe) {
            logger.warning(lbe.getMessage(), lbe);
            logger.warning("Unable to send Operation Change Event for operation '" + this.operation.getId().toString() + " change set '" + changeSet.toString(false));
            ++this.failedToPostCount;
        }
    }
}

