/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;

public class MockResourceAccessor
extends AbstractResourceAccessor {
    private Map<String, String> contentByFileName;

    public MockResourceAccessor() {
        this((Map<String, String>)new HashMap<String, String>());
    }

    public MockResourceAccessor(Map<String, String> contentByFileName) {
        this.contentByFileName = contentByFileName;
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        ByteArrayInputStream stream = null;
        if (this.contentByFileName.containsKey(streamPath)) {
            stream = new ByteArrayInputStream(this.contentByFileName.get(streamPath).getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding()));
        }
        if (stream == null) {
            return null;
        }
        InputStreamList list = new InputStreamList();
        list.add(URI.create(streamPath), stream);
        return list;
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        TreeSet<String> returnSet = new TreeSet<String>();
        for (String file : this.contentByFileName.keySet()) {
            if (!file.startsWith(path)) continue;
            returnSet.add(file);
        }
        return returnSet;
    }

    @Override
    public SortedSet<String> describeLocations() {
        return new TreeSet<String>(Collections.singletonList("MockResouceAccessor.java"));
    }
}

