/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import liquibase.repackaged.com.opencsv.bean.AbstractBeanField;
import liquibase.repackaged.com.opencsv.bean.AbstractCsvConverter;
import liquibase.repackaged.com.opencsv.bean.BeanField;
import liquibase.repackaged.com.opencsv.bean.ComplexFieldMapEntry;
import liquibase.repackaged.com.opencsv.bean.ConverterCurrency;
import liquibase.repackaged.com.opencsv.bean.ConverterDate;
import liquibase.repackaged.com.opencsv.bean.ConverterEnum;
import liquibase.repackaged.com.opencsv.bean.ConverterNumber;
import liquibase.repackaged.com.opencsv.bean.ConverterPrimitiveTypes;
import liquibase.repackaged.com.opencsv.bean.ConverterUUID;
import liquibase.repackaged.com.opencsv.bean.CsvConverter;
import liquibase.repackaged.com.opencsv.bean.CsvDate;
import liquibase.repackaged.com.opencsv.bean.CsvDates;
import liquibase.repackaged.com.opencsv.bean.CsvIgnore;
import liquibase.repackaged.com.opencsv.bean.CsvNumber;
import liquibase.repackaged.com.opencsv.bean.CsvNumbers;
import liquibase.repackaged.com.opencsv.bean.CsvRecurse;
import liquibase.repackaged.com.opencsv.bean.FieldAccess;
import liquibase.repackaged.com.opencsv.bean.FieldMap;
import liquibase.repackaged.com.opencsv.bean.HeaderIndex;
import liquibase.repackaged.com.opencsv.bean.MappingStrategy;
import liquibase.repackaged.com.opencsv.exceptions.CsvBadConverterException;
import liquibase.repackaged.com.opencsv.exceptions.CsvBeanIntrospectionException;
import liquibase.repackaged.com.opencsv.exceptions.CsvChainedException;
import liquibase.repackaged.com.opencsv.exceptions.CsvConstraintViolationException;
import liquibase.repackaged.com.opencsv.exceptions.CsvDataTypeMismatchException;
import liquibase.repackaged.com.opencsv.exceptions.CsvFieldAssignmentException;
import liquibase.repackaged.com.opencsv.exceptions.CsvRecursionException;
import liquibase.repackaged.com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import liquibase.repackaged.com.opencsv.exceptions.CsvValidationException;
import liquibase.repackaged.org.apache.commons.collections4.ListValuedMap;
import liquibase.repackaged.org.apache.commons.collections4.MapIterator;
import liquibase.repackaged.org.apache.commons.collections4.MultiValuedMap;
import liquibase.repackaged.org.apache.commons.collections4.SetUtils;
import liquibase.repackaged.org.apache.commons.collections4.multimap.ArrayListValuedHashMap;
import liquibase.repackaged.org.apache.commons.lang3.ArrayUtils;
import liquibase.repackaged.org.apache.commons.lang3.ObjectUtils;
import liquibase.repackaged.org.apache.commons.lang3.StringUtils;
import liquibase.repackaged.org.apache.commons.lang3.reflect.FieldUtils;

public abstract class AbstractMappingStrategy<I, K extends Comparable<K>, C extends ComplexFieldMapEntry<I, K, T>, T>
implements MappingStrategy<T> {
    private static final Set<Class> FORBIDDEN_CLASSES_FOR_RECURSION = new HashSet<Class>(Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Long.TYPE, Character.TYPE));
    protected Class<? extends T> type;
    protected final HeaderIndex headerIndex = new HeaderIndex();
    private RecursiveType recursiveTypeTree;
    private MultiValuedMap<Class<?>, Field> ignoredFields = new ArrayListValuedHashMap();
    protected Locale errorLocale = Locale.getDefault();
    protected String profile = "";

    protected abstract K chooseMultivaluedFieldIndexFromHeaderIndex(int var1);

    protected abstract FieldMap<I, K, ? extends C, T> getFieldMap();

    protected Set<Class<? extends Annotation>> getBindingAnnotations() {
        return Collections.emptySet();
    }

    protected void loadAnnotatedFieldMap(ListValuedMap<Class<?>, Field> fields) {
    }

    protected abstract void loadUnadornedFieldMap(ListValuedMap<Class<?>, Field> var1);

    protected abstract void initializeFieldMap();

    protected abstract BeanField<T, K> findField(int var1);

    protected abstract void verifyLineLength(int var1) throws CsvRequiredFieldEmptyException;

    protected Map<Class<?>, Object> createBean() throws CsvBeanIntrospectionException, IllegalStateException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        HashMap instanceMap = new HashMap();
        try {
            T rootBean = this.type.newInstance();
            instanceMap.put(this.type, rootBean);
            AbstractMappingStrategy.createSubordinateBeans(this.recursiveTypeTree, instanceMap, rootBean);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
            CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("bean.instantiation.impossible"));
            csve.initCause(e2);
            throw csve;
        }
        return instanceMap;
    }

    private static void createSubordinateBeans(RecursiveType typeTree, Map<Class<?>, Object> instanceMap, Object containingObject) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        for (Map.Entry<FieldAccess<Object>, RecursiveType> entry : typeTree.getRecursiveMembers().entrySet()) {
            Object childObject = entry.getKey().getField(containingObject);
            if (childObject == null) {
                childObject = entry.getValue().type.newInstance();
                entry.getKey().setField(containingObject, childObject);
            }
            instanceMap.put(entry.getValue().getType(), childObject);
            AbstractMappingStrategy.createSubordinateBeans(entry.getValue(), instanceMap, childObject);
        }
    }

    protected Map<Class<?>, Object> indexBean(T bean) throws IllegalAccessException, InvocationTargetException {
        HashMap instanceMap = new HashMap();
        instanceMap.put(this.type, bean);
        AbstractMappingStrategy.indexSubordinateBeans(this.recursiveTypeTree, instanceMap, bean);
        return instanceMap;
    }

    private static void indexSubordinateBeans(RecursiveType typeTree, Map<Class<?>, Object> instanceMap, Object containingObject) throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<FieldAccess<Object>, RecursiveType> entry : typeTree.getRecursiveMembers().entrySet()) {
            Object childObject = containingObject == null ? null : entry.getKey().getField(containingObject);
            instanceMap.put(entry.getValue().getType(), childObject);
            AbstractMappingStrategy.indexSubordinateBeans(entry.getValue(), instanceMap, childObject);
        }
    }

    public abstract String findHeader(int var1);

    @Override
    public String[] generateHeader(T bean) throws CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.before.header"));
        }
        if (this.headerIndex.isEmpty()) {
            String[] header = this.getFieldMap().generateHeader(bean);
            this.headerIndex.initializeHeaderIndex(header);
            return header;
        }
        return this.headerIndex.getHeaderIndex();
    }

    String getColumnName(int col) {
        return this.headerIndex.getByPosition(col);
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    @Override
    public T populateNewBean(String[] line) throws CsvBeanIntrospectionException, CsvFieldAssignmentException, CsvChainedException {
        this.verifyLineLength(line.length);
        Map<Class<?>, Object> beanTree = this.createBean();
        CsvChainedException chainedException = null;
        for (int col = 0; col < line.length; ++col) {
            try {
                this.setFieldValue(beanTree, line[col], col);
                continue;
            }
            catch (CsvFieldAssignmentException e2) {
                if (chainedException != null) {
                    chainedException.add(e2);
                    continue;
                }
                chainedException = new CsvChainedException(e2);
            }
        }
        if (chainedException != null) {
            if (chainedException.hasOnlyOneException()) {
                throw chainedException.getFirstException();
            }
            throw chainedException;
        }
        return (T)beanTree.get(this.type);
    }

    @Override
    public void setType(Class<? extends T> type) throws CsvBadConverterException {
        this.type = type;
        this.loadFieldMap();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = StringUtils.defaultString(profile);
    }

    @Override
    public void ignoreFields(MultiValuedMap<Class<?>, Field> fields) throws IllegalArgumentException {
        if (fields == null) {
            this.ignoredFields = new ArrayListValuedHashMap();
        } else {
            this.ignoredFields = fields;
            MapIterator<Class<?>, Field> it2 = this.ignoredFields.mapIterator();
            it2.forEachRemaining(t2 -> {
                Field f2 = (Field)it2.getValue();
                if (t2 == null || f2 == null || !f2.getDeclaringClass().isAssignableFrom((Class<?>)t2)) {
                    throw new IllegalArgumentException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("ignore.field.inconsistent"));
                }
            });
        }
        if (this.type != null) {
            this.loadFieldMap();
        }
    }

    protected List<Field> filterIgnoredFields(Class<?> type, Field[] fields) {
        LinkedList<Field> filteredFields = new LinkedList<Field>();
        for (Field f2 : fields) {
            HashSet<String> ignoredProfiles;
            CsvIgnore ignoreAnnotation = f2.getAnnotation(CsvIgnore.class);
            HashSet<String> hashSet = ignoredProfiles = ignoreAnnotation == null ? SetUtils.emptySet() : new HashSet<String>(Arrays.asList(ignoreAnnotation.profiles()));
            if (this.ignoredFields.containsMapping(type, f2) || ignoredProfiles.contains(this.profile) || ignoredProfiles.contains("")) continue;
            filteredFields.add(f2);
        }
        return filteredFields;
    }

    protected void loadFieldMap() throws CsvBadConverterException {
        this.initializeFieldMap();
        this.recursiveTypeTree = this.loadRecursiveClasses(this.type, new HashSet());
        Map<Boolean, ListValuedMap<Class<?>, Field>> partitionedFields = this.partitionFields();
        if (!partitionedFields.get(Boolean.TRUE).isEmpty()) {
            this.loadAnnotatedFieldMap(partitionedFields.get(Boolean.TRUE));
        } else {
            this.loadUnadornedFieldMap(partitionedFields.get(Boolean.FALSE));
        }
    }

    protected boolean isForbiddenClassForRecursion(Class<?> type) {
        return FORBIDDEN_CLASSES_FOR_RECURSION.contains(type);
    }

    protected RecursiveType loadRecursiveClasses(Class<?> newType, Set<Class<?>> encounteredTypes) {
        if (this.isForbiddenClassForRecursion(newType)) {
            throw new CsvRecursionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("recursion.on.primitive"), newType);
        }
        if (encounteredTypes.contains(newType)) {
            throw new CsvRecursionException(String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("recursive.type.encountered.twice"), newType.toString()), newType);
        }
        encounteredTypes.add(newType);
        RecursiveType localRecursiveTypeTree = new RecursiveType(newType);
        for (Field f2 : this.filterIgnoredFields(newType, FieldUtils.getFieldsWithAnnotation(newType, CsvRecurse.class))) {
            Set<Class<Annotation>> bindingAnnotations = this.getBindingAnnotations();
            if (bindingAnnotations.stream().anyMatch(f2::isAnnotationPresent)) {
                throw new CsvRecursionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("recursion.binding.mutually.exclusive"), f2.getType());
            }
            localRecursiveTypeTree.addRecursiveMember(new FieldAccess<Object>(f2), this.loadRecursiveClasses(f2.getType(), encounteredTypes));
        }
        return localRecursiveTypeTree;
    }

    private void assembleCompleteFieldList(RecursiveType root, ListValuedMap<Class<?>, Field> encounteredFields) {
        encounteredFields.putAll(root.type, this.filterIgnoredFields(root.type, FieldUtils.getAllFields(root.type)));
        root.getRecursiveMembers().values().forEach(f2 -> this.assembleCompleteFieldList((RecursiveType)f2, encounteredFields));
    }

    protected Map<Boolean, ListValuedMap<Class<?>, Field>> partitionFields() {
        ArrayListValuedHashMap allFields = new ArrayListValuedHashMap();
        this.assembleCompleteFieldList(this.recursiveTypeTree, allFields);
        Set<Class<Annotation>> bindingAnnotations = this.getBindingAnnotations();
        TreeMap returnValue = new TreeMap();
        returnValue.put(Boolean.TRUE, new ArrayListValuedHashMap());
        returnValue.put(Boolean.FALSE, new ArrayListValuedHashMap());
        allFields.entries().stream().filter(entry -> !((Field)entry.getValue()).isSynthetic()).forEach(entry -> {
            if (bindingAnnotations.stream().anyMatch(a2 -> ((Field)entry.getValue()).isAnnotationPresent((Class<? extends Annotation>)a2))) {
                ((ListValuedMap)returnValue.get(Boolean.TRUE)).put(entry.getKey(), entry.getValue());
            } else {
                ((ListValuedMap)returnValue.get(Boolean.FALSE)).put(entry.getKey(), entry.getValue());
            }
        });
        return returnValue;
    }

    protected BeanField<T, K> instantiateCustomConverter(Class<? extends AbstractBeanField<T, K>> converter) throws CsvBadConverterException {
        try {
            BeanField c2 = converter.newInstance();
            c2.setErrorLocale(this.errorLocale);
            return c2;
        }
        catch (IllegalAccessException | InstantiationException oldEx) {
            CsvBadConverterException newEx = new CsvBadConverterException(converter, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("custom.converter.invalid"), converter.getCanonicalName()));
            newEx.initCause(oldEx);
            throw newEx;
        }
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
        if (this.getFieldMap() != null) {
            this.getFieldMap().setErrorLocale(this.errorLocale);
            this.getFieldMap().values().forEach(f2 -> f2.setErrorLocale(this.errorLocale));
        }
    }

    protected void setFieldValue(Map<Class<?>, Object> beanTree, String value, int column) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException, CsvValidationException {
        BeanField<T, K> beanField = this.findField(column);
        if (beanField != null) {
            Object subordinateBean = beanTree.get(beanField.getType());
            beanField.setFieldValue(subordinateBean, value, this.findHeader(column));
        }
    }

    @Override
    public String[] transmuteBean(T bean) throws CsvFieldAssignmentException, CsvChainedException {
        Map<Class<?>, Object> instanceMap;
        int numColumns = this.headerIndex.findMaxIndex() + 1;
        ArrayList<String> contents = new ArrayList<String>(Math.max(numColumns, 0));
        try {
            instanceMap = this.indexBean(bean);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            CsvBeanIntrospectionException csve = new CsvBeanIntrospectionException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.introspecting.beans"));
            csve.initCause(e2);
            throw csve;
        }
        CsvChainedException chainedException = null;
        int i2 = 0;
        while (i2 < numColumns) {
            BeanField<T, K> firstBeanField = this.findField(i2);
            K firstIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i2);
            String[] fields = ArrayUtils.EMPTY_STRING_ARRAY;
            if (firstBeanField != null) {
                try {
                    fields = firstBeanField.write(instanceMap.get(firstBeanField.getType()), firstIndex);
                }
                catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e3) {
                    if (chainedException != null) {
                        chainedException.add(e3);
                    }
                    chainedException = new CsvChainedException(e3);
                }
            }
            if (fields.length == 0) {
                contents.add("");
                ++i2;
                continue;
            }
            contents.add(StringUtils.defaultString(fields[0]));
            int j2 = 1;
            int displacedIndex = i2 + j2;
            BeanField<T, K> subsequentBeanField = this.findField(displacedIndex);
            K subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(displacedIndex);
            while (j2 < fields.length && displacedIndex < numColumns && Objects.equals(firstBeanField, subsequentBeanField) && Objects.equals(firstIndex, subsequentIndex)) {
                contents.add(StringUtils.defaultString(fields[j2]));
                displacedIndex = i2 + ++j2;
                subsequentBeanField = this.findField(displacedIndex);
                subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(displacedIndex);
            }
            i2 = displacedIndex;
            if (i2 >= numColumns) continue;
            subsequentBeanField = this.findField(i2);
            subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i2);
            while (Objects.equals(firstBeanField, subsequentBeanField) && Objects.equals(firstIndex, subsequentIndex) && i2 < numColumns) {
                contents.add("");
                subsequentBeanField = this.findField(++i2);
                subsequentIndex = this.chooseMultivaluedFieldIndexFromHeaderIndex(i2);
            }
        }
        if (chainedException != null) {
            if (chainedException.hasOnlyOneException()) {
                throw chainedException.getFirstException();
            }
            throw chainedException;
        }
        return contents.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    protected CsvConverter determineConverter(Field field, Class<?> elementType, String locale, String writeLocale, Class<? extends AbstractCsvConverter> customConverter) throws CsvBadConverterException {
        CsvConverter converter;
        if (customConverter != null && !customConverter.equals(AbstractCsvConverter.class)) {
            try {
                converter = customConverter.newInstance();
            }
            catch (IllegalAccessException | InstantiationException oldEx) {
                CsvBadConverterException newEx = new CsvBadConverterException(customConverter, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("custom.converter.invalid"), customConverter.getCanonicalName()));
                newEx.initCause(oldEx);
                throw newEx;
            }
            converter.setType(elementType);
            converter.setLocale(locale);
            converter.setWriteLocale(writeLocale);
            converter.setErrorLocale(this.errorLocale);
        } else if (field.isAnnotationPresent(CsvDate.class) || field.isAnnotationPresent(CsvDates.class)) {
            CsvDate annotation = (CsvDate)this.selectAnnotationForProfile(field.getAnnotationsByType(CsvDate.class), CsvDate::profiles);
            if (annotation == null) {
                throw new CsvBadConverterException(CsvDate.class, String.format(ResourceBundle.getBundle("opencsv").getString("profile.not.found.date"), this.profile));
            }
            String readFormat = annotation.value();
            String writeFormat = annotation.writeFormatEqualsReadFormat() ? readFormat : annotation.writeFormat();
            String readChrono = annotation.chronology();
            String writeChrono = annotation.writeChronologyEqualsReadChronology() ? readChrono : annotation.writeChronology();
            converter = new ConverterDate(elementType, locale, writeLocale, this.errorLocale, readFormat, writeFormat, readChrono, writeChrono);
        } else if (field.isAnnotationPresent(CsvNumber.class) || field.isAnnotationPresent(CsvNumbers.class)) {
            CsvNumber annotation = (CsvNumber)this.selectAnnotationForProfile(field.getAnnotationsByType(CsvNumber.class), CsvNumber::profiles);
            if (annotation == null) {
                throw new CsvBadConverterException(CsvNumber.class, String.format(ResourceBundle.getBundle("opencsv").getString("profile.not.found.number"), this.profile));
            }
            String readFormat = annotation.value();
            String writeFormat = annotation.writeFormatEqualsReadFormat() ? readFormat : annotation.writeFormat();
            converter = new ConverterNumber(elementType, locale, writeLocale, this.errorLocale, readFormat, writeFormat);
        } else {
            converter = elementType.equals(Currency.class) ? new ConverterCurrency(this.errorLocale) : (elementType.isEnum() ? new ConverterEnum(elementType, locale, writeLocale, this.errorLocale) : (elementType.equals(UUID.class) ? new ConverterUUID(this.errorLocale) : new ConverterPrimitiveTypes(elementType, locale, writeLocale, this.errorLocale)));
        }
        return converter;
    }

    protected <A extends Annotation> A selectAnnotationForProfile(A[] annotations, Function<A, String[]> getProfiles) {
        A defaultAnnotation = null;
        for (A annotation : annotations) {
            String[] profilesForAnnotation;
            for (String p2 : profilesForAnnotation = getProfiles.apply(annotation)) {
                if (this.profile.equals(p2)) {
                    return annotation;
                }
                if (!"".equals(p2)) continue;
                defaultAnnotation = annotation;
            }
        }
        return defaultAnnotation;
    }

    protected static class RecursiveType {
        private final Class<?> type;
        private final Map<FieldAccess<Object>, RecursiveType> recursiveMembers = new HashMap<FieldAccess<Object>, RecursiveType>();

        RecursiveType(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void addRecursiveMember(FieldAccess<Object> member, RecursiveType memberType) {
            this.recursiveMembers.put(member, memberType);
        }

        public Map<FieldAccess<Object>, RecursiveType> getRecursiveMembers() {
            return this.recursiveMembers;
        }
    }
}

