/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.List;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Project;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class SyncHubCommand
extends AbstractSelfConfiguratingCommand<CommandResult> {
    private String url;
    private String changeLogFile;
    private String hubConnectionId;
    private String hubProjectId;
    private Database database;
    private boolean failIfOnline = true;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getHubConnectionId() {
        return this.hubConnectionId;
    }

    public void setHubConnectionId(String hubConnectionId) {
        this.hubConnectionId = hubConnectionId;
    }

    public String getHubProjectId() {
        return this.hubProjectId;
    }

    public void setHubProjectId(String hubProjectId) {
        this.hubProjectId = hubProjectId;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public boolean isFailIfOnline() {
        return this.failIfOnline;
    }

    public void setFailIfOnline(boolean failIfOnline) {
        this.failIfOnline = failIfOnline;
    }

    @Override
    public String getName() {
        return "syncHub";
    }

    @Override
    public CommandValidationErrors validate() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CommandResult run() throws Exception {
        Connection connectionToSync;
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (!hubServiceFactory.isOnline()) {
            if (!this.failIfOnline) return new CommandResult("Sync skipped, offline", true);
            return new CommandResult("The command syncHub requires access to Liquibase Hub: " + hubServiceFactory.getOfflineReason() + ".  Learn more at https://hub.liquibase.com", false);
        }
        if (this.hubConnectionId != null && this.hubProjectId != null) {
            String message = "The syncHub command requires only one valid hubConnectionId or hubProjectId or unique URL. Please remove extra values.";
            Scope.getCurrentScope().getLog(this.getClass()).severe(message);
            return new CommandResult(message, false);
        }
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (this.hubConnectionId == null) {
            Project project = null;
            if (StringUtil.isNotEmpty(this.changeLogFile)) {
                ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
                DatabaseChangeLog databaseChangeLog = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, resourceAccessor).parse(this.changeLogFile, new ChangeLogParameters(), resourceAccessor);
                String changeLogId = databaseChangeLog.getChangeLogId();
                if (changeLogId == null) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Changelog " + this.changeLogFile + " has not been registered with Liquibase Hub. Cannot use it to help determine project.");
                } else {
                    HubChangeLog changeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId));
                    if (changeLog == null) {
                        return new CommandResult("Changelog " + this.changeLogFile + " has an unrecognized changeLogId.", false);
                    }
                    project = changeLog.getProject();
                }
            } else if (this.hubProjectId != null) {
                project = hubService.getProject(UUID.fromString(this.hubProjectId));
                if (project == null) {
                    return new CommandResult("Project Id '" + this.hubProjectId + "' does not exist or you do not have access to it", false);
                }
            } else {
                Scope.getCurrentScope().getLog(this.getClass()).info("No project, connection, or changeLogFile specified. Searching for jdbcUrl across the entire organization.");
            }
            Connection searchConnection = new Connection().setJdbcUrl(this.url).setProject(project);
            List<Connection> connections = hubService.getConnections(searchConnection);
            if (connections.size() == 0) {
                if (project == null) {
                    return new CommandResult("The url " + this.url + " does not match any defined connections. To auto-create a connection, please specify a 'changeLogFile=<changeLogFileName>' in liquibase.properties or the command line which contains a registered changeLogId.", false);
                }
                Connection inputConnection = new Connection();
                inputConnection.setJdbcUrl(this.url);
                inputConnection.setProject(project);
                connectionToSync = hubService.createConnection(inputConnection);
            } else {
                if (connections.size() != 1) return new CommandResult("The url " + this.url + " is used by more than one connection. Please specify 'hubConnectionId=<hubConnectionId>' or 'changeLogFile=<changeLogFileName>' in liquibase.properties or the command line.", false);
                connectionToSync = connections.get(0);
            }
        } else {
            List<Connection> connections = hubService.getConnections(new Connection().setId(UUID.fromString(this.hubConnectionId)));
            if (connections.size() == 0) {
                return new CommandResult("Hub connection Id " + this.hubConnectionId + " was either not found, or you do not have access", false);
            }
            connectionToSync = connections.get(0);
        }
        Scope.child(Scope.Attr.database, (Object)this.database, () -> {
            ChangeLogHistoryService historyService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
            List<RanChangeSet> ranChangeSets = historyService.getRanChangeSets();
            hubService.setRanChangeSets(connectionToSync, ranChangeSets);
        });
        return new CommandResult();
    }
}

