/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.util.List;
import java.util.UUID;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.HubUpdater;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.model.Connection;
import liquibase.hub.model.HubChangeLog;
import liquibase.hub.model.Project;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class InternalSyncHubCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"internalSyncHub"};
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<UUID> HUB_CONNECTION_ID_ARG;
    public static final CommandArgumentDefinition<UUID> HUB_PROJECT_ID_ARG;
    public static final CommandArgumentDefinition<Boolean> CONTINUE_IF_CONNECTION_AND_PROJECT_ID_BOTH_SET_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<Boolean> FAIL_IF_OFFLINE_ARG;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        Connection connectionToSync;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        HubServiceFactory hubServiceFactory = Scope.getCurrentScope().getSingleton(HubServiceFactory.class);
        if (!hubServiceFactory.isOnline()) {
            if (commandScope.getArgumentValue(FAIL_IF_OFFLINE_ARG).booleanValue()) {
                throw new CommandExecutionException("The command syncHub requires access to Liquibase Hub: " + hubServiceFactory.getOfflineReason() + ".  Learn more at https://hub.liquibase.com");
            }
            Scope.getCurrentScope().getUI().sendMessage("Sync skipped, offline");
            return;
        }
        Boolean favorConnectionId = commandScope.getArgumentValue(CONTINUE_IF_CONNECTION_AND_PROJECT_ID_BOTH_SET_ARG);
        UUID hubConnectionId = commandScope.getArgumentValue(HUB_CONNECTION_ID_ARG);
        if (!favorConnectionId.booleanValue() && hubConnectionId != null && commandScope.getArgumentValue(HUB_PROJECT_ID_ARG) != null) {
            String message = "The syncHub command requires only one valid hubConnectionId or hubProjectId or unique URL. Please remove extra values.";
            Scope.getCurrentScope().getLog(this.getClass()).severe(message);
            throw new CommandExecutionException(message);
        }
        HubChangeLog hubChangeLog = null;
        HubService hubService = Scope.getCurrentScope().getSingleton(HubServiceFactory.class).getService();
        if (hubConnectionId == null) {
            Project project = null;
            if (StringUtil.isNotEmpty(commandScope.getArgumentValue(CHANGELOG_FILE_ARG))) {
                ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
                String changelogFile = commandScope.getArgumentValue(CHANGELOG_FILE_ARG);
                DatabaseChangeLog databaseChangeLog = ChangeLogParserFactory.getInstance().getParser(changelogFile, resourceAccessor).parse(changelogFile, new ChangeLogParameters(), resourceAccessor);
                String changeLogId = databaseChangeLog.getChangeLogId();
                if (changeLogId == null) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Changelog " + changelogFile + " has not been registered with Liquibase Hub. Cannot use it to help determine project.");
                } else {
                    hubChangeLog = hubService.getHubChangeLog(UUID.fromString(changeLogId), "*");
                    if (hubChangeLog == null) {
                        throw new CommandExecutionException("Changelog " + changelogFile + " has an unrecognized changeLogId.");
                    }
                    if (hubChangeLog.isDeleted()) {
                        String message = "\nThe operation did not complete and will not be reported to Hub because the\nregistered changelog has been deleted by someone in your organization.\nLearn more at http://hub.liquibase.com";
                        throw new LiquibaseHubException(message);
                    }
                    project = hubChangeLog.getProject();
                }
            } else if (commandScope.getArgumentValue(HUB_PROJECT_ID_ARG) != null) {
                project = hubService.getProject(commandScope.getArgumentValue(HUB_PROJECT_ID_ARG));
                if (project == null) {
                    throw new CommandExecutionException("Project Id '" + commandScope.getArgumentValue(HUB_PROJECT_ID_ARG) + "' does not exist or you do not have access to it");
                }
            } else {
                Scope.getCurrentScope().getLog(this.getClass()).info("No project, connection, or changeLogFile specified. Searching for jdbcUrl across the entire organization.");
            }
            String url = commandScope.getArgumentValue(URL_ARG);
            Connection searchConnection = new Connection().setJdbcUrl(url).setProject(project);
            List<Connection> connections = hubService.getConnections(searchConnection);
            if (connections.size() == 0) {
                if (project == null) {
                    throw new CommandExecutionException("The url " + url + " does not match any defined connections. To auto-create a connection, please specify a 'changeLogFile=<changeLogFileName>' in liquibase.properties or the command line which contains a registered changeLogId.");
                }
                Connection inputConnection = new Connection();
                inputConnection.setJdbcUrl(url);
                inputConnection.setProject(project);
                connectionToSync = hubService.createConnection(inputConnection);
            } else {
                if (connections.size() != 1) throw new CommandExecutionException("The url " + url + " is used by more than one connection. Please specify 'hubConnectionId=<hubConnectionId>' or 'changeLogFile=<changeLogFileName>' in liquibase.properties or the command line.");
                connectionToSync = connections.get(0);
            }
        } else {
            List<Connection> connections = hubService.getConnections(new Connection().setId(hubConnectionId));
            if (connections.size() == 0) {
                throw new CommandExecutionException("Hub connection Id " + hubConnectionId + " was either not found, or you do not have access");
            }
            connectionToSync = connections.get(0);
        }
        Database database = commandScope.getArgumentValue(DATABASE_ARG);
        Scope.child(Scope.Attr.database, (Object)database, () -> {
            ChangeLogHistoryService historyService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
            List<RanChangeSet> ranChangeSets = historyService.getRanChangeSets();
            hubService.setRanChangeSets(connectionToSync, ranChangeSets);
        });
        if (hubChangeLog == null || !hubChangeLog.isInactive()) return;
        String message = "\nThe command completed and reported to Hub, but the changelog has been deactivated by someone in your organization.\nTo synchronize your changelog, checkout the latest from source control or run \"deactivatechangelog\".\nAfter that, commands run against this changelog will not be reported to Hub until \"registerchangelog\" is run again.\nLearn more at http://hub.liquibase.com";
        Scope.getCurrentScope().getLog(HubUpdater.class).warning(message);
        Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        URL_ARG = builder.argument("url", String.class).build();
        CHANGELOG_FILE_ARG = builder.argument("changelogFile", String.class).build();
        HUB_CONNECTION_ID_ARG = builder.argument("hubConnectionId", UUID.class).build();
        HUB_PROJECT_ID_ARG = builder.argument("hubProjectId", UUID.class).build();
        CONTINUE_IF_CONNECTION_AND_PROJECT_ID_BOTH_SET_ARG = builder.argument("continueIfConnectionAndProjectIdBothSet", Boolean.class).defaultValue(false).description("Continue if both connection ID and project ID are set").build();
        DATABASE_ARG = builder.argument("database", Database.class).build();
        FAIL_IF_OFFLINE_ARG = builder.argument("failIfOffline", Boolean.class).defaultValue(true).build();
    }
}

