/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.util.StringUtil;

public class WarnOnTableTruncate
extends AbstractNotAllowedToContainRule {
    public WarnOnTableTruncate() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<Pattern> getReservedPhrase() {
        return Arrays.asList(Pattern.compile("^[\\s]*truncate[\\s]+(table)[\\s]+"), Pattern.compile("^\\s*truncate[\\s]+?(table)?\\s*\\["));
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that changesets which result in tables being truncated are reviewed carefully to prevent the unintentional loss of data.  Review this changeset to confirm that the referenced table is being truncated safely.";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a table is being truncated so that they can ensure that truncating the table won't lead to unintentional loss of data.";
    }

    @Override
    public String getName() {
        return "Warn when 'TRUNCATE TABLE' detected";
    }

    @Override
    public String getShortName() {
        return "ChangeTruncateTableWarn";
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return null;
    }

    @Override
    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return new ArrayList<Class<? extends Change>>();
    }

    @Override
    public boolean doCheck(Change change) {
        return false;
    }

    @Override
    public boolean doCheck(AbstractSQLChange object) {
        if (StringUtil.isEmpty(((AbstractSQLChange)object).getSql())) {
            return false;
        }
        if (super.doCheck((AbstractSQLChange)object)) {
            return true;
        }
        object = StringUtil.stripComments(((AbstractSQLChange)object).getSql()).toLowerCase();
        return Pattern.compile("^[\\s]*truncate[\\s]+[^\\s]").matcher((CharSequence)object).find();
    }
}

