/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.AbstractLiquibaseUpdateMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseUpdate
extends AbstractLiquibaseUpdateMojo {
    @PropertyElement
    protected boolean dropFirst;
    @PropertyElement
    protected UpdateSummaryEnum showSummary;
    @PropertyElement
    protected UpdateSummaryOutputEnum showSummaryOutput;

    @Override
    protected void doUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.dropFirst) {
            liquibase.dropAll();
        }
        try {
            Scope.child((String)"rollbackOnError", (Object)this.rollbackOnError, () -> {
                if (this.changesToApply > 0) {
                    liquibase.update(this.changesToApply, new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()));
                } else {
                    liquibase.update(this.toTag, new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()));
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof LiquibaseException) {
                this.handleUpdateException((LiquibaseException)exception);
                throw (LiquibaseException)exception;
            }
            throw new LiquibaseException((Throwable)exception);
        }
    }

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        liquibase.setShowSummary(this.showSummary);
        liquibase.setShowSummaryOutput(this.showSummaryOutput);
        return liquibase;
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "drop first? " + this.dropFirst));
    }
}

