/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import liquibase.Liquibase;
import liquibase.UpdateSummaryEnum;
import liquibase.UpdateSummaryOutputEnum;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public abstract class AbstractLiquibaseUpdateMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected int changesToApply;
    protected String toTag;
    @PropertyElement
    protected boolean rollbackOnError;
    @PropertyElement
    protected UpdateSummaryEnum showSummary;
    @PropertyElement
    protected UpdateSummaryOutputEnum showSummaryOutput;

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        this.doUpdate(liquibase);
    }

    protected abstract void doUpdate(Liquibase var1) throws LiquibaseException;

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        liquibase.setShowSummary(this.showSummary);
        liquibase.setShowSummaryOutput(this.showSummaryOutput);
        return liquibase;
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "number of changes to apply: " + this.changesToApply));
    }

    protected void handleUpdateException(LiquibaseException exception) throws LiquibaseException {
        try {
            CommandScope liquibaseCommand = new CommandScope(new String[]{"internalRollbackOnError"});
            liquibaseCommand.addArgumentValue("database", (Object)this.getLiquibase().getDatabase());
            liquibaseCommand.addArgumentValue("exception", (Object)exception);
            liquibaseCommand.addArgumentValue("listener", (Object)this.defaultChangeExecListener);
            liquibaseCommand.addArgumentValue("rollbackOnError", (Object)this.rollbackOnError);
            liquibaseCommand.execute();
        }
        catch (IllegalArgumentException ignoredCommandNotFound) {
            throw exception;
        }
    }
}

