/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;

public class ConversionServiceAdapterGenerator {
    private final Clock clock;

    public ConversionServiceAdapterGenerator(Clock clock) {
        this.clock = clock;
    }

    public void writeConversionServiceAdapter(ConversionServiceAdapterDescriptor descriptor, Writer out) {
        try {
            JavaFile.builder((String)descriptor.getAdapterClassName().packageName(), (TypeSpec)this.createConversionServiceTypeSpec(descriptor)).build().writeTo((Appendable)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec createConversionServiceTypeSpec(ConversionServiceAdapterDescriptor descriptor) {
        FieldSpec conversionServiceFieldSpec = ConversionServiceAdapterGenerator.buildConversionServiceFieldSpec();
        return TypeSpec.classBuilder((ClassName)descriptor.getAdapterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildGeneratedAnnotationSpec()).addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0])).addField(conversionServiceFieldSpec).addMethod(ConversionServiceAdapterGenerator.buildConstructorSpec(descriptor, conversionServiceFieldSpec)).addMethods(ConversionServiceAdapterGenerator.buildMappingMethods(descriptor, conversionServiceFieldSpec)).build();
    }

    private static MethodSpec buildConstructorSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec constructorParameterSpec = ConversionServiceAdapterGenerator.buildConstructorParameterSpec(descriptor, conversionServiceFieldSpec);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(constructorParameterSpec).addStatement("this.$N = $N", new Object[]{conversionServiceFieldSpec, constructorParameterSpec}).build();
    }

    private static ParameterSpec buildConstructorParameterSpec(ConversionServiceAdapterDescriptor descriptor, FieldSpec conversionServiceFieldSpec) {
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)conversionServiceFieldSpec.type, (String)conversionServiceFieldSpec.name, (Modifier[])new Modifier[]{Modifier.FINAL});
        if (StringUtils.isNotEmpty((CharSequence)descriptor.getConversionServiceBeanName())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildQualifierANnotation(descriptor));
        }
        if (Boolean.TRUE.equals(descriptor.isLazyAnnotatedConversionServiceBean())) {
            parameterBuilder.addAnnotation(ConversionServiceAdapterGenerator.buildLazyAnnotation());
        }
        return parameterBuilder.build();
    }

    private static AnnotationSpec buildQualifierANnotation(ConversionServiceAdapterDescriptor descriptor) {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Qualifier", (String[])new String[0])).addMember("value", "$S", new Object[]{descriptor.getConversionServiceBeanName()}).build();
    }

    private static AnnotationSpec buildLazyAnnotation() {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.context.annotation", (String)"Lazy", (String[])new String[0])).build();
    }

    private static String simpleName(TypeName typeName) {
        return ConversionServiceAdapterGenerator.rawType(typeName).simpleName();
    }

    private static ClassName rawType(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return (ClassName)typeName;
    }

    private static Iterable<MethodSpec> buildMappingMethods(ConversionServiceAdapterDescriptor descriptor, FieldSpec injectedConversionServiceFieldSpec) {
        return descriptor.getFromToMappings().stream().map(sourceTargetPair -> {
            ParameterSpec sourceParameterSpec = ConversionServiceAdapterGenerator.buildSourceParameterSpec((TypeName)sourceTargetPair.getLeft());
            return MethodSpec.methodBuilder((String)("map" + ConversionServiceAdapterGenerator.simpleName((TypeName)sourceTargetPair.getLeft()) + "To" + ConversionServiceAdapterGenerator.simpleName((TypeName)sourceTargetPair.getRight()))).addParameter(sourceParameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)sourceTargetPair.getRight()).addStatement("return $N.convert($N, $T.class)", new Object[]{injectedConversionServiceFieldSpec, sourceParameterSpec, ConversionServiceAdapterGenerator.rawType((TypeName)sourceTargetPair.getRight())}).build();
        }).collect(Collectors.toList());
    }

    private static ParameterSpec buildSourceParameterSpec(TypeName sourceClassName) {
        return ParameterSpec.builder((TypeName)sourceClassName, (String)"source", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
    }

    private static FieldSpec buildConversionServiceFieldSpec() {
        return FieldSpec.builder((TypeName)ClassName.get((String)"org.springframework.core.convert", (String)"ConversionService", (String[])new String[0]), (String)"conversionService", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private AnnotationSpec buildGeneratedAnnotationSpec() {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"javax.annotation", (String)"Generated", (String[])new String[0])).addMember("value", "$S", new Object[]{ConversionServiceAdapterGenerator.class.getName()}).addMember("date", "$S", new Object[]{DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now(this.clock))}).build();
    }
}

