/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.mapstruct.extensions.spring.converter.FromToMapping;
import org.mapstruct.extensions.spring.converter.TypeNameUtils;

public class DelegatingConverterDescriptor {
    private final ClassName converterClassName;
    private final FromToMapping fromToMapping;
    private final ClassName originalMapperClassName;
    private final String originalMapperMethodName;

    public DelegatingConverterDescriptor(ExecutableElement annotatedMethod, ProcessingEnvironment processingEnv) {
        List<? extends VariableElement> parameterList = annotatedMethod.getParameters();
        TypeMirror returnType = annotatedMethod.getReturnType();
        if (parameterList.size() != 1 || TypeKind.VOID.equals((Object)returnType.getKind())) {
            String errorMessage = "Can only generate a delegating converter for methods with exactly one parameter and non-void return type.";
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Can only generate a delegating converter for methods with exactly one parameter and non-void return type.", annotatedMethod);
            throw new IllegalArgumentException("Can only generate a delegating converter for methods with exactly one parameter and non-void return type.");
        }
        this.fromToMapping = new FromToMapping().source(TypeName.get((TypeMirror)parameterList.iterator().next().asType())).target(TypeName.get((TypeMirror)returnType));
        this.originalMapperClassName = ClassName.get((TypeElement)((TypeElement)annotatedMethod.getEnclosingElement()));
        this.converterClassName = ClassName.get((String)this.originalMapperClassName.packageName(), (String)String.format("%sTo%sConverter", TypeNameUtils.collectionOfNameIfApplicable(processingEnv, this.fromToMapping.getSource()), TypeNameUtils.collectionOfNameIfApplicable(processingEnv, this.fromToMapping.getTarget())), (String[])new String[0]);
        this.originalMapperMethodName = annotatedMethod.getSimpleName().toString();
    }

    public ClassName getConverterClassName() {
        return this.converterClassName;
    }

    public FromToMapping getFromToMapping() {
        return this.fromToMapping;
    }

    public ClassName getOriginalMapperClassName() {
        return this.originalMapperClassName;
    }

    public String getOriginalMapperMethodName() {
        return this.originalMapperMethodName;
    }
}

