package org.mapstruct.ap.prism;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.type.TypeMirror;
import net.java.dev.hickory.prism.internal.*;
import java.util.HashMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
/** A Prism representing an {@code @org.mapstruct.Mapping} annotation. 
  */ 
public class MappingPrism {
    /** store prism value of target */
    private String _target;

    /** store prism value of source */
    private String _source;

    /** store prism value of dateFormat */
    private String _dateFormat;

    /** store prism value of constant */
    private String _constant;

    /** store prism value of expression */
    private String _expression;

    /** store prism value of ignore */
    private Boolean _ignore;

    /** store prism value of qualifiedBy */
    private List<TypeMirror> _qualifiedBy;

    /** store prism value of resultType */
    private TypeMirror _resultType;

    /** store prism value of dependsOn */
    private List<String> _dependsOn;

    /**
      * An instance of the Values inner class whose
      * methods return the AnnotationValues used to build this prism. 
      * Primarily intended to support using Messager.
      */
    public final Values values;
    /** Return a prism representing the {@code @org.mapstruct.Mapping} annotation on 'e'. 
      * similar to {@code e.getAnnotation(org.mapstruct.Mapping.class)} except that 
      * an instance of this class rather than an instance of {@code org.mapstruct.Mapping}
      * is returned.
      */
    public static MappingPrism getInstanceOn(Element e) {
        AnnotationMirror m = getMirror("org.mapstruct.Mapping",e);
        if(m == null) return null;
        return getInstance(m);
   }

    /** Return a prism of the {@code @org.mapstruct.Mapping} annotation whose mirror is mirror. 
      */
    public static MappingPrism getInstance(AnnotationMirror mirror) {
        return new MappingPrism(mirror);
    }

    private MappingPrism(AnnotationMirror mirror) {
        for(ExecutableElement key : mirror.getElementValues().keySet()) {
            memberValues.put(key.getSimpleName().toString(),mirror.getElementValues().get(key));
        }
        for(ExecutableElement member : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            defaults.put(member.getSimpleName().toString(),member.getDefaultValue());
        }
        _target = getValue("target",String.class);
        _source = getValue("source",String.class);
        _dateFormat = getValue("dateFormat",String.class);
        _constant = getValue("constant",String.class);
        _expression = getValue("expression",String.class);
        _ignore = getValue("ignore",Boolean.class);
        _qualifiedBy = getArrayValues("qualifiedBy",TypeMirror.class);
        _resultType = getValue("resultType",TypeMirror.class);
        _dependsOn = getArrayValues("dependsOn",String.class);
        this.values = new Values(memberValues);
        this.mirror = mirror;
        this.isValid = valid;
    }

    /** 
      * Returns a String representing the value of the {@code java.lang.String target()} member of the Annotation.
      * @see org.mapstruct.Mapping#target()
      */ 
    public String target() { return _target; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String source()} member of the Annotation.
      * @see org.mapstruct.Mapping#source()
      */ 
    public String source() { return _source; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String dateFormat()} member of the Annotation.
      * @see org.mapstruct.Mapping#dateFormat()
      */ 
    public String dateFormat() { return _dateFormat; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String constant()} member of the Annotation.
      * @see org.mapstruct.Mapping#constant()
      */ 
    public String constant() { return _constant; }

    /** 
      * Returns a String representing the value of the {@code java.lang.String expression()} member of the Annotation.
      * @see org.mapstruct.Mapping#expression()
      */ 
    public String expression() { return _expression; }

    /** 
      * Returns a Boolean representing the value of the {@code boolean ignore()} member of the Annotation.
      * @see org.mapstruct.Mapping#ignore()
      */ 
    public Boolean ignore() { return _ignore; }

    /** 
      * Returns a List<TypeMirror> representing the value of the {@code qualifiedBy()} member of the Annotation.
      * @see org.mapstruct.Mapping#qualifiedBy()
      */ 
    public List<TypeMirror> qualifiedBy() { return _qualifiedBy; }

    /** 
      * Returns a TypeMirror representing the value of the {@code java.lang.Class<?> resultType()} member of the Annotation.
      * @see org.mapstruct.Mapping#resultType()
      */ 
    public TypeMirror resultType() { return _resultType; }

    /** 
      * Returns a List<String> representing the value of the {@code dependsOn()} member of the Annotation.
      * @see org.mapstruct.Mapping#dependsOn()
      */ 
    public List<String> dependsOn() { return _dependsOn; }

    /**
      * Determine whether the underlying AnnotationMirror has no errors.
      * True if the underlying AnnotationMirror has no errors.
      * When true is returned, none of the methods will return null.
      * When false is returned, a least one member will either return null, or another
      * prism that is not valid.
      */
    public final boolean isValid;
    
    /**
      * The underlying AnnotationMirror of the annotation
      * represented by this Prism. 
      * Primarily intended to support using Messager.
      */
    public final AnnotationMirror mirror;
    /**
      * A class whose members corespond to those of org.mapstruct.Mapping
      * but which each return the AnnotationValue corresponding to
      * that member in the model of the annotations. Returns null for
      * defaulted members. Used for Messager, so default values are not useful.
      */
    public static class Values {
       private Map<String,AnnotationValue> values;
       private Values(Map<String,AnnotationValue> values) {
           this.values = values;
       }    
       /** Return the AnnotationValue corresponding to the target() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue target(){ return values.get("target");}
       /** Return the AnnotationValue corresponding to the source() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue source(){ return values.get("source");}
       /** Return the AnnotationValue corresponding to the dateFormat() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue dateFormat(){ return values.get("dateFormat");}
       /** Return the AnnotationValue corresponding to the constant() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue constant(){ return values.get("constant");}
       /** Return the AnnotationValue corresponding to the expression() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue expression(){ return values.get("expression");}
       /** Return the AnnotationValue corresponding to the ignore() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue ignore(){ return values.get("ignore");}
       /** Return the AnnotationValue corresponding to the qualifiedBy() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue qualifiedBy(){ return values.get("qualifiedBy");}
       /** Return the AnnotationValue corresponding to the resultType() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue resultType(){ return values.get("resultType");}
       /** Return the AnnotationValue corresponding to the dependsOn() 
         * member of the annotation, or null when the default value is implied.
         */
       public AnnotationValue dependsOn(){ return values.get("dependsOn");}
    }
    private Map<String,AnnotationValue> defaults = new HashMap<String,AnnotationValue>(10);
    private Map<String,AnnotationValue> memberValues = new HashMap<String,AnnotationValue>(10);
    private boolean valid = true;

    private <T> T getValue(String name, Class<T> clazz) {
        T result = MappingPrism.getValue(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    } 

    private <T> List<T> getArrayValues(String name, final Class<T> clazz) {
        List<T> result = MappingPrism.getArrayValues(memberValues,defaults,name,clazz);
        if(result == null) valid = false;
        return result;
    }
    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror m :target.getAnnotationMirrors()) {
            CharSequence mfqn = ((TypeElement)m.getAnnotationType().asElement()).getQualifiedName();
            if(fqn.contentEquals(mfqn)) return m;
        }
        return null;
    }
    private static <T> T getValue(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(clazz.isInstance(av.getValue())) return clazz.cast(av.getValue());
        return null;
    }
    private static <T> List<T> getArrayValues(Map<String,AnnotationValue> memberValues, Map<String,AnnotationValue> defaults, String name, final Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if(av == null) av = defaults.get(name);
        if(av == null) {
            return null;
        }
        if(av.getValue() instanceof List) {
            List<T> result = new ArrayList<T>();
            for(AnnotationValue v : getValueAsList(av)) {
                if(clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                } else{
                    return null;
                }
            }
            return result;
        } else {
            return null;
        }
    }
    @SuppressWarnings("unchecked")
    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List<AnnotationValue>)av.getValue();
    }
}
