/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.BuilderFinisherMethodResolver;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedTargetPropertyMappingHolder;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.ObjectFactoryMethodResolver;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.BeanMapping;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class BeanMappingMethod
extends NormalTypeMappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final Type returnTypeToConstruct;
    private final BuilderType returnTypeBuilder;
    private final MethodReference finalizerMethod;

    private BeanMappingMethod(Method method, Collection<String> existingVariableNames, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type returnTypeToConstruct, BuilderType returnTypeBuilder, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences, MethodReference finalizerMethod) {
        super(method, existingVariableNames, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.returnTypeBuilder = returnTypeBuilder;
        this.finalizerMethod = finalizerMethod;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings);
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            this.mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : propertyMappings) {
                if (!sourceParameter.getName().equals(mapping.getSourceBeanName())) continue;
                mappingsOfParameter.add(mapping);
                this.constantMappings.remove(mapping);
            }
        }
        this.returnTypeToConstruct = returnTypeToConstruct;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public List<PropertyMapping> propertyMappingsByParameter(Parameter parameter) {
        return this.mappingsByParameter.get(parameter.getName());
    }

    public Type getReturnTypeToConstruct() {
        return this.returnTypeToConstruct;
    }

    public MethodReference getFinalizerMethod() {
        return this.finalizerMethod;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        if (this.returnTypeToConstruct != null) {
            types.addAll(this.returnTypeToConstruct.getImportTypes());
        }
        if (this.returnTypeBuilder != null) {
            types.add(this.returnTypeBuilder.getOwningType());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (!sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanMappingMethod that = (BeanMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return this.propertyMappings != null ? this.propertyMappings.equals(that.propertyMappings) : that.propertyMappings == null;
    }

    private static class SourceMethodSingleMapping
    implements SingleMappingByTargetPropertyNameFunction {
        private final SourceMethod sourceMethod;

        private SourceMethodSingleMapping(SourceMethod sourceMethod) {
            this.sourceMethod = sourceMethod;
        }

        @Override
        public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
            return this.sourceMethod.getSingleMappingByTargetPropertyName(targetPropertyName);
        }
    }

    private static class EmptySingleMapping
    implements SingleMappingByTargetPropertyNameFunction {
        private EmptySingleMapping() {
        }

        @Override
        public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
            return null;
        }
    }

    private static interface SingleMappingByTargetPropertyNameFunction {
        public Mapping getSingleMappingByTargetPropertyName(String var1);
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private Method method;
        private BuilderType returnTypeBuilder;
        private Map<String, Accessor> unprocessedTargetProperties;
        private Map<String, Accessor> unprocessedSourceProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private final Set<String> existingVariableNames = new HashSet<String>();
        private Map<String, List<Mapping>> methodMappings;
        private SingleMappingByTargetPropertyNameFunction singleMapping;
        private final Map<String, List<Mapping>> unprocessedDefinedTargets = new HashMap<String, List<Mapping>>();

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder returnTypeBuilder(BuilderType returnTypeBuilder) {
            this.returnTypeBuilder = returnTypeBuilder;
            return this;
        }

        public Builder sourceMethod(SourceMethod sourceMethod) {
            this.singleMapping = new SourceMethodSingleMapping(sourceMethod);
            this.method = sourceMethod;
            return this;
        }

        public Builder forgedMethod(Method method) {
            this.singleMapping = new EmptySingleMapping();
            this.method = method;
            return this;
        }

        public BeanMappingMethod build() {
            boolean mappingErrorOccured;
            BeanMapping beanMapping = this.method.getMappingOptions().getBeanMapping();
            SelectionParameters selectionParameters = beanMapping != null ? beanMapping.getSelectionParameters() : null;
            Type returnTypeToConstruct = null;
            MethodReference factoryMethod = null;
            if (!this.method.getReturnType().isVoid()) {
                Type returnTypeImpl = this.getReturnTypeToConstructFromSelectionParameters(selectionParameters);
                if (returnTypeImpl != null) {
                    factoryMethod = this.getFactoryMethod(returnTypeImpl, selectionParameters);
                    if (factoryMethod != null || this.canResultTypeFromBeanMappingBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    }
                } else if (this.isBuilderRequired()) {
                    returnTypeImpl = this.returnTypeBuilder.getBuilder();
                    factoryMethod = this.getFactoryMethod(returnTypeImpl, selectionParameters);
                    if (factoryMethod != null || this.canReturnTypeBeConstructed(returnTypeImpl)) {
                        returnTypeToConstruct = returnTypeImpl;
                    }
                } else if (!this.method.isUpdateMethod() && ((factoryMethod = this.getFactoryMethod(returnTypeImpl = this.method.getReturnType(), selectionParameters)) != null || this.canReturnTypeBeConstructed(returnTypeImpl))) {
                    returnTypeToConstruct = returnTypeImpl;
                }
            }
            Type resultTypeToMap = returnTypeToConstruct == null ? this.method.getResultType() : returnTypeToConstruct;
            this.methodMappings = this.method.getMappingOptions().getMappings();
            CollectionMappingStrategyPrism cms = this.method.getMapperConfiguration().getCollectionMappingStrategy();
            Map<String, Accessor> accessors = resultTypeToMap.getPropertyWriteAccessors(cms);
            this.targetProperties = accessors.keySet();
            this.unprocessedTargetProperties = new LinkedHashMap<String, Accessor>(accessors);
            this.unprocessedSourceProperties = new LinkedHashMap<String, Accessor>();
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
                if (sourceParameter.getType().isPrimitive() || sourceParameter.getType().isArrayType()) continue;
                Map<String, Accessor> readAccessors = sourceParameter.getType().getPropertyReadAccessors();
                for (String key : readAccessors.keySet()) {
                    this.unprocessedSourceProperties.put(key, readAccessors.get(key));
                }
            }
            this.existingVariableNames.addAll(this.method.getParameterNames());
            if (beanMapping != null) {
                for (String ignoreUnmapped : beanMapping.getIgnoreUnmappedSourceProperties()) {
                    this.unprocessedSourceProperties.remove(ignoreUnmapped);
                }
            }
            if (mappingErrorOccured = this.handleDefinedMappings()) {
                return null;
            }
            if (!this.method.getMappingOptions().isRestrictToDefinedMappings()) {
                this.applyPropertyNameBasedMapping();
                this.applyParameterNameBasedMapping();
            }
            this.handleUnprocessedDefinedTargets();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            this.reportErrorForUnmappedSourcePropertiesIfRequired();
            NullValueMappingStrategyPrism nullValueMappingStrategy = beanMapping != null ? beanMapping.getNullValueMappingStrategy() : null;
            boolean mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(nullValueMappingStrategy);
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, resultTypeToMap, selectionParameters, this.ctx, this.existingVariableNames);
            if (factoryMethod != null && this.method instanceof ForgedMethod) {
                ((ForgedMethod)this.method).addThrownTypes(factoryMethod.getThrownTypes());
            }
            MethodReference finalizeMethod = null;
            if (this.shouldCallFinalizerMethod(returnTypeToConstruct)) {
                finalizeMethod = this.getFinalizerMethod();
            }
            return new BeanMappingMethod(this.method, this.existingVariableNames, this.propertyMappings, factoryMethod, mapNullToDefault, returnTypeToConstruct, this.returnTypeBuilder, beforeMappingMethods, afterMappingMethods, finalizeMethod);
        }

        private boolean isBuilderRequired() {
            return this.returnTypeBuilder != null && (!this.method.isUpdateMethod() || !this.method.isMappingTargetAssignableToReturnType());
        }

        private boolean shouldCallFinalizerMethod(Type returnTypeToConstruct) {
            if (returnTypeToConstruct == null) {
                return false;
            }
            if (returnTypeToConstruct.isAssignableTo(this.method.getReturnType())) {
                return false;
            }
            return this.returnTypeBuilder != null;
        }

        private MethodReference getFinalizerMethod() {
            return BuilderFinisherMethodResolver.getBuilderFinisherMethod(this.method, this.returnTypeBuilder, this.ctx);
        }

        private void handleUnprocessedDefinedTargets() {
            Iterator<Map.Entry<String, List<Mapping>>> iterator = this.unprocessedDefinedTargets.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<String, List<Mapping>> entry = iterator.next();
                String propertyName = entry.getKey();
                if (!this.unprocessedTargetProperties.containsKey(propertyName)) continue;
                List<Parameter> sourceParameters = this.method.getSourceParameters();
                boolean forceUpdateMethod = sourceParameters.size() > 1;
                for (Parameter sourceParameter : sourceParameters) {
                    SourceReference reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(propertyName).build();
                    MappingOptions mappingOptions = this.extractAdditionalOptions(propertyName, true);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(this.unprocessedTargetProperties.get(propertyName))).targetReadAccessor(this.getTargetPropertyReadAccessor(propertyName))).targetPropertyName(propertyName)).sourceReference(reference).existingVariableNames(this.existingVariableNames)).dependsOn(mappingOptions.collectNestedDependsOn())).forgeMethodWithMappingOptions(mappingOptions).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
                    if (propertyMapping == null) continue;
                    this.unprocessedTargetProperties.remove(propertyName);
                    this.unprocessedSourceProperties.remove(propertyName);
                    iterator.remove();
                    this.propertyMappings.add(propertyMapping);
                    continue block0;
                }
            }
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping.getName(), propertyMapping.getDependsOn());
            }
            final GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                java.util.Collections.sort(this.propertyMappings, new Comparator<PropertyMapping>(){

                    @Override
                    public int compare(PropertyMapping o1, PropertyMapping o2) {
                        return graphAnalyzer.getTraversalSequence(o1.getName()) - graphAnalyzer.getTraversalSequence(o2.getName());
                    }
                });
            }
        }

        private Type getReturnTypeToConstructFromSelectionParameters(SelectionParameters selectionParams) {
            if (selectionParams != null && selectionParams.getResultType() != null) {
                return this.ctx.getTypeFactory().getType(selectionParams.getResultType());
            }
            return null;
        }

        private boolean canResultTypeFromBeanMappingBeConstructed(Type resultType) {
            boolean error = true;
            if (resultType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), BeanMappingPrism.getInstanceOn((Element)this.method.getExecutable()).mirror, Message.BEANMAPPING_ABSTRACT, resultType, this.method.getResultType());
                error = false;
            } else if (!resultType.isAssignableTo(this.method.getResultType())) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), BeanMappingPrism.getInstanceOn((Element)this.method.getExecutable()).mirror, Message.BEANMAPPING_NOT_ASSIGNABLE, resultType, this.method.getResultType());
                error = false;
            } else if (!resultType.hasEmptyAccessibleContructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), BeanMappingPrism.getInstanceOn((Element)this.method.getExecutable()).mirror, Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, resultType);
                error = false;
            }
            return error;
        }

        private boolean canReturnTypeBeConstructed(Type returnType) {
            boolean error = true;
            if (returnType.isAbstract()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_ABSTRACT_RETURN_TYPE, returnType);
                error = false;
            } else if (!returnType.hasEmptyAccessibleContructor()) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_NO_SUITABLE_CONSTRUCTOR, returnType);
                error = false;
            }
            return error;
        }

        private MethodReference getFactoryMethod(Type returnTypeImpl, SelectionParameters selectionParameters) {
            MethodReference factoryMethod = ObjectFactoryMethodResolver.getFactoryMethod(this.method, returnTypeImpl, selectionParameters, this.ctx);
            if (factoryMethod == null && this.returnTypeBuilder != null) {
                factoryMethod = ObjectFactoryMethodResolver.getBuilderFactoryMethod(this.method, this.returnTypeBuilder);
            }
            return factoryMethod;
        }

        private boolean handleDefinedMappings() {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            if (this.method.getMappingOptions().hasNestedTargetReferences()) {
                errorOccurred = this.handleDefinedNestedTargetMapping(handledTargets);
            }
            for (Map.Entry<String, List<Mapping>> entry : this.methodMappings.entrySet()) {
                for (Mapping mapping : entry.getValue()) {
                    TargetReference targetReference = mapping.getTargetReference();
                    if (targetReference.isValid()) {
                        List<PropertyEntry> sourceEntries;
                        String target = Collections.first(targetReference.getPropertyEntries()).getFullName();
                        if (!handledTargets.contains(target) && this.handleDefinedMapping(mapping, handledTargets)) {
                            errorOccurred = true;
                        }
                        if (mapping.getSourceReference() == null || !mapping.getSourceReference().isValid() || (sourceEntries = mapping.getSourceReference().getPropertyEntries()).isEmpty()) continue;
                        String source = Collections.first(sourceEntries).getFullName();
                        this.unprocessedSourceProperties.remove(source);
                        continue;
                    }
                    errorOccurred = true;
                }
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
                this.unprocessedDefinedTargets.remove(handledTarget);
            }
            return errorOccurred;
        }

        private boolean handleDefinedNestedTargetMapping(Set<String> handledTargets) {
            NestedTargetPropertyMappingHolder holder = new NestedTargetPropertyMappingHolder.Builder().mappingContext(this.ctx).method(this.method).existingVariableNames(this.existingVariableNames).build();
            this.unprocessedSourceParameters.removeAll(holder.getProcessedSourceParameters());
            this.propertyMappings.addAll(holder.getPropertyMappings());
            handledTargets.addAll(holder.getHandledTargets());
            for (Map.Entry<PropertyEntry, List<Mapping>> entry : holder.getUnprocessedDefinedTarget().entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                this.unprocessedDefinedTargets.put(entry.getKey().getName(), entry.getValue());
            }
            return holder.hasErrorOccurred();
        }

        private boolean handleDefinedMapping(Mapping mapping, Set<String> handledTargets) {
            boolean errorOccured = false;
            PropertyMapping propertyMapping = null;
            TargetReference targetRef = mapping.getTargetReference();
            PropertyEntry targetProperty = Collections.first(targetRef.getPropertyEntries());
            String propertyName = targetProperty.getName();
            for (String dependency : mapping.getDependsOn()) {
                if (this.targetProperties.contains(dependency)) continue;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                errorOccured = true;
            }
            if (mapping.isIgnored()) {
                propertyMapping = null;
                handledTargets.add(mapping.getTargetName());
            } else if (mapping.getSourceName() != null) {
                SourceReference sourceRef = mapping.getSourceReference();
                if (sourceRef.isValid()) {
                    propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).sourcePropertyName(mapping.getSourceName())).sourceReference(sourceRef).selectionParameters(mapping.getSelectionParameters()).formattingParameters(mapping.getFormattingParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).defaultValue(mapping.getDefaultValue()).defaultJavaExpression(mapping.getDefaultJavaExpression()).mirror(mapping.getMirror())).nullValueCheckStrategy(mapping.getNullValueCheckStrategy()).nullValuePropertyMappingStrategy(mapping.getNullValuePropertyMappingStrategy()).build();
                    handledTargets.add(propertyName);
                    this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                } else {
                    errorOccured = true;
                }
            } else if (mapping.getConstant() != null && !this.unprocessedDefinedTargets.containsKey(propertyName)) {
                propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression(mapping.getConstant()).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).formattingParameters(mapping.getFormattingParameters()).selectionParameters(mapping.getSelectionParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(mapping.getTargetName());
            } else if (mapping.getJavaExpression() != null && !this.unprocessedDefinedTargets.containsKey(propertyName)) {
                propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames(this.existingVariableNames)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).dependsOn(mapping.getDependsOn())).mirror(mapping.getMirror())).build();
                handledTargets.add(mapping.getTargetName());
            }
            if (propertyMapping != null) {
                this.propertyMappings.add(propertyMapping);
            }
            return errorOccured;
        }

        private void applyPropertyNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                String targetPropertyName = targetProperty.getKey();
                PropertyMapping propertyMapping = null;
                if (propertyMapping == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        Type sourceType = sourceParameter.getType();
                        if (sourceType.isPrimitive() || sourceType.isArrayType()) continue;
                        PropertyMapping newPropertyMapping = null;
                        Accessor sourceReadAccessor = sourceParameter.getType().getPropertyReadAccessors().get(targetPropertyName);
                        Accessor sourcePresenceChecker = sourceParameter.getType().getPropertyPresenceCheckers().get(targetPropertyName);
                        if (sourceReadAccessor != null) {
                            Mapping mapping = this.singleMapping.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                            DeclaredType declaredSourceType = (DeclaredType)sourceParameter.getType().getTypeMirror();
                            SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(this.ctx.getTypeFactory().getReturnType(declaredSourceType, sourceReadAccessor)).readAccessor(sourceReadAccessor).presenceChecker(sourcePresenceChecker).name(targetProperty.getKey()).build();
                            newPropertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetPropertyName))).targetPropertyName(targetPropertyName)).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).defaultValue(mapping != null ? mapping.getDefaultValue() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).forgeMethodWithMappingOptions(this.extractAdditionalOptions(targetPropertyName, false)).nullValueCheckStrategy(mapping != null ? mapping.getNullValueCheckStrategy() : null).nullValuePropertyMappingStrategy(mapping != null ? mapping.getNullValuePropertyMappingStrategy() : null).mirror(mapping != null ? mapping.getMirror() : null)).build();
                            this.unprocessedSourceParameters.remove(sourceParameter);
                        }
                        if (propertyMapping != null && newPropertyMapping != null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                            break;
                        }
                        if (newPropertyMapping == null) continue;
                        propertyMapping = newPropertyMapping;
                    }
                }
                if (propertyMapping == null) continue;
                this.propertyMappings.add(propertyMapping);
                targetPropertyEntriesIterator.remove();
                this.unprocessedDefinedTargets.remove(targetPropertyName);
                this.unprocessedSourceProperties.remove(targetPropertyName);
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    Mapping mapping = this.singleMapping.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetProperty.getKey()))).targetPropertyName(targetProperty.getKey())).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).forgeMethodWithMappingOptions(this.extractAdditionalOptions(targetProperty.getKey(), false)).nullValueCheckStrategy(mapping != null ? mapping.getNullValueCheckStrategy() : null).nullValuePropertyMappingStrategy(mapping != null ? mapping.getNullValuePropertyMappingStrategy() : null).mirror(mapping != null ? mapping.getMirror() : null)).build();
                    this.propertyMappings.add(propertyMapping);
                    targetPropertyEntriesIterator.remove();
                    sourceParameters.remove();
                    this.unprocessedDefinedTargets.remove(targetProperty.getKey());
                    this.unprocessedSourceProperties.remove(targetProperty.getKey());
                }
            }
        }

        private MappingOptions extractAdditionalOptions(String targetProperty, boolean restrictToDefinedMappings) {
            MappingOptions additionalOptions = null;
            if (this.unprocessedDefinedTargets.containsKey(targetProperty)) {
                HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
                for (Mapping mapping : this.unprocessedDefinedTargets.get(targetProperty)) {
                    mappings.put(mapping.getTargetName(), java.util.Collections.singletonList(mapping));
                }
                additionalOptions = MappingOptions.forMappingsOnly(mappings, restrictToDefinedMappings);
            }
            return additionalOptions;
        }

        private Accessor getTargetPropertyReadAccessor(String propertyName) {
            return this.method.getResultType().getPropertyReadAccessors().get(propertyName);
        }

        private ReportingPolicyPrism getUnmappedTargetPolicy() {
            MappingOptions mappingOptions = this.method.getMappingOptions();
            if (mappingOptions.getBeanMapping() != null && mappingOptions.getBeanMapping().getReportingPolicy() != null) {
                return mappingOptions.getBeanMapping().getReportingPolicy();
            }
            MapperConfiguration mapperSettings = MapperConfiguration.getInstanceOn(this.ctx.getMapperTypeElement());
            return mapperSettings.unmappedTargetPolicy(this.ctx.getOptions());
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicyPrism unmappedTargetPolicy = this.getUnmappedTargetPolicy();
            if (this.method instanceof ForgedMethod && this.targetProperties.isEmpty()) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (forgedMethod.getHistory() == null) {
                    Type sourceType = this.method.getParameters().get(0).getType();
                    Type targetType = this.method.getReturnType();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_NOT_FOUND, sourceType, targetType, targetType, sourceType);
                } else {
                    ForgedMethodHistory history = forgedMethod.getHistory();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_WITH_HISTORY_NOT_FOUND, history.createSourcePropertyErrorMessage(), history.getTargetType(), history.createTargetPropertyName(), history.getTargetType(), history.getSourceType());
                }
            } else if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", "))};
                if (this.method instanceof ForgedMethod) {
                    msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_WARNING;
                    String sourceErrorMessage = this.method.getParameters().get(0).getType().toString();
                    String targetErrorMessage = this.method.getReturnType().toString();
                    if (((ForgedMethod)this.method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)this.method).getHistory();
                        sourceErrorMessage = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = MessageFormat.format("\"{0} {1}\"", history.getTargetType(), history.createTargetPropertyName());
                    }
                    args = new Object[]{args[0], sourceErrorMessage, targetErrorMessage};
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
            }
        }

        private ReportingPolicyPrism getUnmappedSourcePolicy() {
            MapperConfiguration mapperSettings = MapperConfiguration.getInstanceOn(this.ctx.getMapperTypeElement());
            return mapperSettings.unmappedSourcePolicy();
        }

        private void reportErrorForUnmappedSourcePropertiesIfRequired() {
            ReportingPolicyPrism unmappedSourcePolicy = this.getUnmappedSourcePolicy();
            if (!this.unprocessedSourceProperties.isEmpty() && unmappedSourcePolicy.requiresReport()) {
                Message msg = unmappedSourcePolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_SOURCES_ERROR : Message.BEANMAPPING_UNMAPPED_SOURCES_WARNING;
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedSourceProperties.size(), Strings.join(this.unprocessedSourceProperties.keySet(), ", "))};
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
            }
        }
    }
}

