/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.prism.MapMappingPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class MapMapping {
    private final SelectionParameters keySelectionParameters;
    private final SelectionParameters valueSelectionParameters;
    private final FormattingParameters keyFormattingParameters;
    private final FormattingParameters valueFormattingParameters;
    private final AnnotationMirror mirror;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;

    public static MapMapping fromPrism(MapMappingPrism mapMapping, ExecutableElement method, FormattingMessager messager, Types typeUtils) {
        boolean valueTargetTypeIsDefined;
        if (mapMapping == null) {
            return null;
        }
        NullValueMappingStrategyPrism nullValueMappingStrategy = mapMapping.values.nullValueMappingStrategy() == null ? null : NullValueMappingStrategyPrism.valueOf(mapMapping.nullValueMappingStrategy());
        boolean keyTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.keyTargetType().getKind());
        boolean bl = valueTargetTypeIsDefined = !TypeKind.VOID.equals((Object)mapMapping.valueTargetType().getKind());
        if (mapMapping.keyDateFormat().isEmpty() && mapMapping.keyNumberFormat().isEmpty() && mapMapping.keyQualifiedBy().isEmpty() && mapMapping.keyQualifiedByName().isEmpty() && mapMapping.valueDateFormat().isEmpty() && mapMapping.valueNumberFormat().isEmpty() && mapMapping.valueQualifiedBy().isEmpty() && mapMapping.valueQualifiedByName().isEmpty() && !keyTargetTypeIsDefined && !valueTargetTypeIsDefined && nullValueMappingStrategy == null) {
            messager.printMessage((Element)method, Message.MAPMAPPING_NO_ELEMENTS, new Object[0]);
        }
        SelectionParameters keySelection = new SelectionParameters(mapMapping.keyQualifiedBy(), mapMapping.keyQualifiedByName(), keyTargetTypeIsDefined ? mapMapping.keyTargetType() : null, typeUtils);
        SelectionParameters valueSelection = new SelectionParameters(mapMapping.valueQualifiedBy(), mapMapping.valueQualifiedByName(), valueTargetTypeIsDefined ? mapMapping.valueTargetType() : null, typeUtils);
        FormattingParameters keyFormatting = new FormattingParameters(mapMapping.keyDateFormat(), mapMapping.keyNumberFormat(), mapMapping.mirror, mapMapping.values.keyDateFormat(), method);
        FormattingParameters valueFormatting = new FormattingParameters(mapMapping.valueDateFormat(), mapMapping.valueNumberFormat(), mapMapping.mirror, mapMapping.values.valueDateFormat(), method);
        return new MapMapping(keyFormatting, keySelection, valueFormatting, valueSelection, mapMapping.mirror, nullValueMappingStrategy);
    }

    private MapMapping(FormattingParameters keyFormatting, SelectionParameters keySelectionParameters, FormattingParameters valueFormatting, SelectionParameters valueSelectionParameters, AnnotationMirror mirror, NullValueMappingStrategyPrism nvms) {
        this.keyFormattingParameters = keyFormatting;
        this.keySelectionParameters = keySelectionParameters;
        this.valueFormattingParameters = valueFormatting;
        this.valueSelectionParameters = valueSelectionParameters;
        this.mirror = mirror;
        this.nullValueMappingStrategy = nvms;
    }

    public FormattingParameters getKeyFormattingParameters() {
        return this.keyFormattingParameters;
    }

    public SelectionParameters getKeySelectionParameters() {
        return this.keySelectionParameters;
    }

    public FormattingParameters getValueFormattingParameters() {
        return this.valueFormattingParameters;
    }

    public SelectionParameters getValueSelectionParameters() {
        return this.valueSelectionParameters;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }
}

