/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.server;

import io.netty.buffer.ByteBuf;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.ServerMessage;

public class EofPacket
implements ServerMessage {
    private final short serverStatus;
    private final short warningCount;
    private final boolean ending;
    private final boolean resultSetEnd;

    public EofPacket(short serverStatus, short warningCount, boolean resultSetEnd, boolean ending) {
        this.serverStatus = serverStatus;
        this.warningCount = warningCount;
        this.resultSetEnd = resultSetEnd;
        this.ending = ending;
    }

    public static EofPacket decode(ByteBuf buf, Context context, boolean resultSetEnd) {
        buf.skipBytes(1);
        short warningCount = buf.readShortLE();
        short serverStatus = buf.readShortLE();
        context.setServerStatus(serverStatus);
        return new EofPacket(serverStatus, warningCount, resultSetEnd, resultSetEnd && (serverStatus & 8) == 0);
    }

    public static EofPacket decodeOutputParam(ByteBuf buf, Context context) {
        buf.skipBytes(1);
        short warningCount = buf.readShortLE();
        short serverStatus = (short)(buf.readShortLE() | 0x1000 | 8);
        context.setServerStatus(serverStatus);
        return new EofPacket(serverStatus, warningCount, false, false);
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public short getWarningCount() {
        return this.warningCount;
    }

    @Override
    public boolean ending() {
        return this.ending;
    }

    @Override
    public boolean resultSetEnd() {
        return this.resultSetEnd;
    }

    public String toString() {
        return "EofPacket{serverStatus=" + this.serverStatus + ", warningCount=" + this.warningCount + ", ending=" + this.ending + ", resultSetEnd=" + this.resultSetEnd + '}';
    }
}

