/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.util;

import java.util.Date;
import java.util.HashMap;

public final class TypeConversionSupport {
    private static final HashMap<ConversionKey, Converter> CONVERSION_MAP = new HashMap();

    public static Object convert(Object value, Class<?> toClass) {
        Converter c;
        assert (value != null && toClass != null);
        if (value.getClass() == toClass) {
            return value;
        }
        Class<?> fromClass = value.getClass();
        if (fromClass.isPrimitive()) {
            fromClass = TypeConversionSupport.convertPrimitiveTypeToWrapperType(fromClass);
        }
        if (toClass.isPrimitive()) {
            toClass = TypeConversionSupport.convertPrimitiveTypeToWrapperType(toClass);
        }
        if ((c = CONVERSION_MAP.get(new ConversionKey(fromClass, toClass))) == null) {
            return null;
        }
        return c.convert(value);
    }

    private static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            }
        }
        return rc;
    }

    private TypeConversionSupport() {
    }

    static {
        Converter toStringConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return value.toString();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Boolean.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Byte.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Integer.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Long.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Float.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Double.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(String.class, Boolean.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Boolean.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Byte.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Byte.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Short.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Short.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Integer.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Integer.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Long.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Long.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Float.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Float.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Double.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Double.valueOf((String)value);
            }
        });
        Converter longConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).longValue();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Integer.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Date.class, Long.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Date)value).getTime();
            }
        });
        Converter intConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).intValue();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Integer.class), intConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, Integer.class), intConverter);
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Short.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).shortValue();
            }
        });
        CONVERSION_MAP.put(new ConversionKey(Float.class, Double.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).doubleValue();
            }
        });
    }

    static class ConversionKey {
        final Class<?> from;
        final Class<?> to;
        final int hashCode;

        public ConversionKey(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
            this.hashCode = from.hashCode() ^ to.hashCode() << 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ConversionKey x = (ConversionKey)o;
            return x.from == this.from && x.to == this.to;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    static interface Converter {
        public Object convert(Object var1);
    }
}

