/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.jms.XAConnection;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.messaginghub.pooled.jms.pool.PooledSessionKey;

public class PooledXAConnection
extends PooledConnection {
    private final TransactionManager transactionManager;

    public PooledXAConnection(Connection connection, TransactionManager transactionManager) {
        super(connection);
        this.transactionManager = transactionManager;
    }

    @Override
    protected Session makeSession(PooledSessionKey key) throws JMSException {
        return ((XAConnection)this.connection).createXASession();
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isXa;
            boolean bl = isXa = this.transactionManager != null && this.transactionManager.getStatus() != 6;
            if (isXa) {
                transacted = false;
                ackMode = 2;
            } else if (this.transactionManager != null) {
                transacted = false;
                if (ackMode == 0) {
                    ackMode = 1;
                }
            }
            JmsPoolSession session = (JmsPoolSession)super.createSession(transacted, ackMode);
            if (isXa) {
                session.setIgnoreClose(true);
                session.setIsXa(true);
                this.transactionManager.getTransaction().registerSynchronization((jakarta.transaction.Synchronization)new Synchronization(session));
                this.incrementReferenceCount();
                this.transactionManager.getTransaction().enlistResource(this.createXaResource(session));
            } else {
                session.setIgnoreClose(false);
            }
            return session;
        }
        catch (RollbackException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
        catch (SystemException e) {
            JMSException jmsException = new JMSException("System Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    protected XAResource createXaResource(JmsPoolSession session) throws JMSException {
        return session.getXAResource();
    }

    protected class Synchronization
    implements jakarta.transaction.Synchronization {
        private final JmsPoolSession session;

        private Synchronization(JmsPoolSession session) {
            this.session = session;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.session.setIgnoreClose(false);
                this.session.close();
                PooledXAConnection.this.decrementReferenceCount();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

