/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import org.messaginghub.pooled.jms.JmsPoolMessageConsumer;
import org.messaginghub.pooled.jms.util.JMSExceptionSupport;

public class JmsPoolJMSConsumer
implements JMSConsumer,
AutoCloseable {
    private final JmsPoolMessageConsumer consumer;

    public JmsPoolJMSConsumer(JmsPoolMessageConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void close() {
        try {
            this.consumer.close();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public MessageListener getMessageListener() {
        try {
            return this.consumer.getMessageListener();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public String getMessageSelector() {
        try {
            return this.consumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public void setMessageListener(MessageListener listener) {
        try {
            this.consumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public Message receive() {
        try {
            return this.consumer.receive();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public Message receive(long timeout) {
        try {
            return this.consumer.receive(timeout);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public Message receiveNoWait() {
        try {
            return this.consumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public <T> T receiveBody(Class<T> desired) {
        throw new JMSRuntimeException("Pooled JMSConsumer does not support receiveBody");
    }

    public <T> T receiveBody(Class<T> desired, long timeout) {
        throw new JMSRuntimeException("Pooled JMSConsumer does not support receiveBody");
    }

    public <T> T receiveBodyNoWait(Class<T> desired) {
        throw new JMSRuntimeException("Pooled JMSConsumer does not support receiveBody");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + String.valueOf(this.consumer) + " }";
    }
}

