/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.layout;

import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Map;
import org.metawidget.android.AndroidUtils;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.Facet;
import org.metawidget.android.widget.Stub;
import org.metawidget.android.widget.layout.LinearLayoutConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearLayout
implements AdvancedLayout<View, ViewGroup, AndroidMetawidget> {
    private final int mLabelStyle;

    public LinearLayout() {
        this(new LinearLayoutConfig());
    }

    public LinearLayout(LinearLayoutConfig linearLayoutConfig) {
        this.mLabelStyle = linearLayoutConfig.getLabelStyle();
    }

    @Override
    public void onStartBuild(AndroidMetawidget androidMetawidget) {
    }

    @Override
    public void startContainerLayout(ViewGroup viewGroup, AndroidMetawidget androidMetawidget) {
    }

    @Override
    public void layoutWidget(View view, String string, Map<String, String> map, ViewGroup viewGroup, AndroidMetawidget androidMetawidget) {
        if (view instanceof Stub && ((Stub)view).getChildCount() == 0) {
            return;
        }
        ViewGroup viewGroup2 = this.newViewToAddTo(viewGroup);
        String string2 = androidMetawidget.getLabelString(map);
        boolean bl = SimpleLayoutUtils.needsLabel(string2, string);
        if (bl) {
            TextView textView = new TextView(androidMetawidget.getContext());
            textView.setText((CharSequence)(string2 + ": "));
            AndroidUtils.applyStyle((View)textView, this.mLabelStyle, androidMetawidget);
            viewGroup2.addView((View)textView);
        }
        this.layoutWidget(view, viewGroup2, viewGroup, androidMetawidget, bl);
    }

    @Override
    public void endContainerLayout(ViewGroup viewGroup, AndroidMetawidget androidMetawidget) {
    }

    @Override
    public void onEndBuild(AndroidMetawidget androidMetawidget) {
        Facet facet = androidMetawidget.getFacet("buttons");
        if (facet != null) {
            androidMetawidget.addView((View)facet, new LinearLayout.LayoutParams(-1, -2));
        }
    }

    protected void layoutWidget(View view, ViewGroup viewGroup, ViewGroup viewGroup2, AndroidMetawidget androidMetawidget, boolean bl) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = view instanceof ListView ? new LinearLayout.LayoutParams(-1, 100) : new LinearLayout.LayoutParams(-1, -2);
        }
        this.getLayout(viewGroup2).addView(view, layoutParams);
    }

    protected ViewGroup newViewToAddTo(ViewGroup viewGroup) {
        return viewGroup;
    }

    protected ViewGroup getLayout(ViewGroup viewGroup) {
        return viewGroup;
    }
}

