/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.widgetbuilder;

import android.content.Context;
import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.method.DateKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.AndroidValueAccessor;
import org.metawidget.android.widget.Stub;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidWidgetBuilder
implements WidgetBuilder<View, AndroidMetawidget>,
AndroidValueAccessor {
    @Override
    public Object getValue(View view) {
        if (view instanceof CheckBox) {
            return ((CheckBox)view).isChecked();
        }
        if (view instanceof TextView) {
            CharSequence charSequence = ((TextView)view).getText();
            if (charSequence instanceof SpannableStringBuilder) {
                charSequence = ((Object)charSequence).toString();
            }
            return charSequence;
        }
        if (view instanceof DatePicker) {
            DatePicker datePicker = (DatePicker)view;
            return new Date(datePicker.getYear() - 1900, datePicker.getMonth(), datePicker.getDayOfMonth());
        }
        if (view instanceof Spinner) {
            return ((Spinner)view).getSelectedItem();
        }
        return null;
    }

    @Override
    public boolean setValue(Object object, View view) {
        if (view instanceof CheckBox) {
            ((CheckBox)view).setChecked(((Boolean)object).booleanValue());
            return true;
        }
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)StringUtils.quietValueOf(object));
            return true;
        }
        if (view instanceof DatePicker) {
            Date date = (Date)object;
            ((DatePicker)view).updateDate(1900 + date.getYear(), date.getMonth(), date.getDate());
            return true;
        }
        if (view instanceof Spinner) {
            AdapterView adapterView = (AdapterView)view;
            ArrayAdapter arrayAdapter = (ArrayAdapter)adapterView.getAdapter();
            adapterView.setSelection(arrayAdapter.getPosition(object));
            return true;
        }
        return false;
    }

    @Override
    public View buildWidget(String string, Map<String, String> map, AndroidMetawidget androidMetawidget) {
        Class<?> clazz;
        if ("true".equals(map.get("hidden"))) {
            return new Stub(androidMetawidget.getContext());
        }
        if ("action".equals(string)) {
            return new Stub(androidMetawidget.getContext());
        }
        String string2 = WidgetBuilderUtils.getActualClassOrType(map);
        if (string2 == null) {
            string2 = String.class.getName();
        }
        if (Boolean.class.equals(clazz = ClassUtils.niceForName(string2, this.getClass().getClassLoader())) && "true".equals(map.get("required"))) {
            return new CheckBox(androidMetawidget.getContext());
        }
        if (clazz != null) {
            String string3 = map.get("lookup");
            if (string3 != null && !"".equals(string3)) {
                Spinner spinner = new Spinner(androidMetawidget.getContext());
                List<String> list = CollectionUtils.fromString(string3);
                if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
                    list.add(0, null);
                }
                List<String> list2 = null;
                String string4 = map.get("lookup-labels");
                list2 = CollectionUtils.fromString(string4);
                if (!list2.isEmpty() && WidgetBuilderUtils.needsEmptyLookupItem(map)) {
                    list2.add(0, null);
                }
                LookupArrayAdapter<String> lookupArrayAdapter = new LookupArrayAdapter<String>(androidMetawidget.getContext(), list, list2);
                spinner.setAdapter(lookupArrayAdapter);
                return spinner;
            }
            if (clazz.isPrimitive()) {
                if (Boolean.TYPE.equals(clazz)) {
                    return new CheckBox(androidMetawidget.getContext());
                }
                EditText editText = new EditText(androidMetawidget.getContext());
                if (Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz)) {
                    editText.setKeyListener((KeyListener)new DigitsKeyListener());
                }
                return editText;
            }
            if (String.class.equals(clazz)) {
                String string5;
                EditText editText = new EditText(androidMetawidget.getContext());
                if ("true".equals(map.get("masked"))) {
                    editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                }
                if ("true".equals(map.get("large"))) {
                    editText.setMinLines(3);
                }
                if ((string5 = map.get("maximum-length")) != null && !"".equals(string5)) {
                    editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(Integer.parseInt(string5))});
                }
                return editText;
            }
            if (Date.class.equals(clazz)) {
                if ("true".equals(map.get("required"))) {
                    return new DatePicker(androidMetawidget.getContext());
                }
                EditText editText = new EditText(androidMetawidget.getContext());
                editText.setKeyListener((KeyListener)new DateKeyListener());
                return editText;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                EditText editText = new EditText(androidMetawidget.getContext());
                if (Byte.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                    editText.setKeyListener((KeyListener)new DigitsKeyListener());
                }
                return editText;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new Stub(androidMetawidget.getContext());
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return new EditText(androidMetawidget.getContext());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LookupArrayAdapter<T>
    extends ArrayAdapter<T> {
        private List<String> mLabels;

        public LookupArrayAdapter(Context context, List<T> list, List<String> list2) {
            super(context, 0, list);
            if (list2 != null && !list2.isEmpty()) {
                if (list2.size() != list.size()) {
                    throw MetawidgetException.newException("Labels list must be same size as values list");
                }
                this.mLabels = list2;
            }
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            return this.initView(n, view, viewGroup, 17367048);
        }

        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            return this.initView(n, view, viewGroup, 0x1090009);
        }

        private View initView(int n, View view, ViewGroup viewGroup, int n2) {
            View view2 = view;
            if (view2 == null) {
                Context context = this.getContext();
                if (context != null) {
                    view2 = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(n2, viewGroup, false);
                }
                if (view2 == null) {
                    view2 = new TextView(context);
                }
            }
            if (this.mLabels == null) {
                ((TextView)view2).setText((CharSequence)StringUtils.quietValueOf(this.getItem(n)));
            } else {
                ((TextView)view2).setText((CharSequence)StringUtils.quietValueOf(this.mLabels.get(n)));
            }
            return view2;
        }
    }
}

