/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParserFactory;
import org.metawidget.config.NeedsResourceResolver;
import org.metawidget.config.ResourceResolver;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigReader
implements ResourceResolver {
    static final String IMMUTABLE_NO_CONFIG = "no-config";
    static final LogUtils.Log LOG = LogUtils.getLog(class$org$metawidget$config$ConfigReader == null ? (class$org$metawidget$config$ConfigReader = ConfigReader.class$("org.metawidget.config.ConfigReader")) : class$org$metawidget$config$ConfigReader);
    protected SAXParserFactory mFactory;
    Map<String, XmlUtils.CachingContentHandler> mResourceCache = CollectionUtils.newHashMap();
    Map<String, Map<Integer, Object>> mImmutableByLocationCache = CollectionUtils.newHashMap();
    Map<Class<?>, Map<Object, Object>> mImmutableByClassCache = CollectionUtils.newHashMap();
    Map<String, Pattern> mPatternCache = CollectionUtils.newHashMap();
    static /* synthetic */ Class class$org$metawidget$config$ConfigReader;
    static /* synthetic */ Class class$org$metawidget$iface$Immutable;
    static /* synthetic */ Class class$java$lang$Object;

    public ConfigReader() {
        this.mFactory = SAXParserFactory.newInstance();
        this.mFactory.setNamespaceAware(true);
    }

    public <T> T configure(String string, Class<T> clazz, String[] stringArray) {
        return (T)this.configure(string, (Object)clazz, stringArray);
    }

    public Object configure(String string, Object object, String[] stringArray) {
        ConfigHandler configHandler = new ConfigHandler(object, stringArray);
        String string2 = new StringBuffer().append(string).append(StringUtils.SEPARATOR_FORWARD_SLASH).toString();
        if (object instanceof Class) {
            string2 = new StringBuffer().append(string2).append(((Class)object).getName()).toString();
        } else if (object != null) {
            string2 = new StringBuffer().append(string2).append(object.getClass().getName()).toString();
        }
        string2 = new StringBuffer().append(string2).append(ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).toString();
        Map<Integer, Object> map = this.mImmutableByLocationCache.get(string2);
        if (map == null) {
            map = CollectionUtils.newHashMap();
        }
        configHandler.setImmutableForThisLocationCache(map);
        try {
            XmlUtils.CachingContentHandler cachingContentHandler = this.mResourceCache.get(string2);
            if (cachingContentHandler != null) {
                cachingContentHandler.replay(configHandler);
            } else {
                LOG.debug(new StringBuffer().append("Reading resource from ").append(string2).toString());
                cachingContentHandler = new XmlUtils.CachingContentHandler(configHandler);
                configHandler.setCachingContentHandler(cachingContentHandler);
                this.mFactory.newSAXParser().parse(this.openResource(string), (DefaultHandler)cachingContentHandler);
                this.mResourceCache.put(string2, cachingContentHandler);
                this.mImmutableByLocationCache.put(string2, map);
            }
            return configHandler.getConfigured();
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
    }

    public <T> T configure(InputStream inputStream, Class<T> clazz, String[] stringArray) {
        return (T)this.configure(inputStream, (Object)clazz, stringArray);
    }

    public Object configure(InputStream inputStream, Object object, String[] stringArray) {
        if (inputStream == null) {
            throw MetawidgetException.newException("No input stream specified");
        }
        try {
            ConfigHandler configHandler = new ConfigHandler(object, stringArray);
            this.mFactory.newSAXParser().parse(inputStream, (DefaultHandler)configHandler);
            return configHandler.getConfigured();
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
    }

    @Override
    public InputStream openResource(String string) {
        try {
            return ClassUtils.openResource(string);
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
    }

    protected boolean isNative(String string) {
        if ("null".equals(string)) {
            return true;
        }
        if ("string".equals(string)) {
            return true;
        }
        if ("class".equals(string)) {
            return true;
        }
        if ("pattern".equals(string)) {
            return true;
        }
        if ("int".equals(string)) {
            return true;
        }
        if ("boolean".equals(string)) {
            return true;
        }
        if ("resource".equals(string)) {
            return true;
        }
        if ("url".equals(string)) {
            return true;
        }
        if ("file".equals(string)) {
            return true;
        }
        if ("bundle".equals(string)) {
            return true;
        }
        return "constant".equals(string);
    }

    protected boolean isLazyResolvingNative(String string) {
        return "enum".equals(string);
    }

    protected Object createNative(String string, Class<?> clazz, String string2) throws Exception {
        if ("null".equals(string)) {
            return null;
        }
        if ("string".equals(string)) {
            return string2;
        }
        if ("class".equals(string)) {
            if ("".equals(string2)) {
                return null;
            }
            return Class.forName(string2);
        }
        if ("pattern".equals(string)) {
            Pattern pattern = this.mPatternCache.get(string2);
            if (pattern == null) {
                pattern = Pattern.compile(string2);
                this.mPatternCache.put(string2, pattern);
            }
            return pattern;
        }
        if ("int".equals(string)) {
            return new Integer(string2);
        }
        if ("boolean".equals(string)) {
            return new Boolean(string2);
        }
        if ("bundle".equals(string)) {
            return ResourceBundle.getBundle(string2);
        }
        if ("enum".equals(string)) {
            return string2;
        }
        if ("constant".equals(string)) {
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                return Class.forName(string2.substring(0, n)).getDeclaredField(string2.substring(n + 1)).get(null);
            }
            return clazz.getDeclaredField(string2).get(null);
        }
        if ("resource".equals(string)) {
            return this.openResource(string2);
        }
        if ("url".equals(string)) {
            return new URL(string2).openStream();
        }
        if ("file".equals(string)) {
            return new FileInputStream(string2);
        }
        throw MetawidgetException.newException(new StringBuffer().append("Don't know how to convert '").append(string2).append("' to a ").append(string).toString());
    }

    protected Object createNativeCollection(String string) {
        if ("array".equals(string)) {
            return new Object[0];
        }
        if ("list".equals(string)) {
            return CollectionUtils.newArrayList();
        }
        if ("set".equals(string)) {
            return CollectionUtils.newHashSet();
        }
        return null;
    }

    protected Object createLazyResolvingNative(Object object, Class<?> clazz) {
        if (clazz.isArray() && object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), objectArray.length);
            try {
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                return objectArray2;
            }
            catch (ArrayStoreException arrayStoreException) {
                return null;
            }
        }
        if (clazz.isEnum() && object instanceof String) {
            try {
                Object obj = Enum.valueOf(clazz, (String)object);
                return obj;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    protected boolean isImmutable(Class<?> clazz) {
        return (class$org$metawidget$iface$Immutable == null ? (class$org$metawidget$iface$Immutable = ConfigReader.class$("org.metawidget.iface.Immutable")) : class$org$metawidget$iface$Immutable).isAssignableFrom(clazz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigHandler
    extends DefaultHandler {
        private static final String JAVA_NAMESPACE_PREFIX = "java:";
        private static final int ENCOUNTERED_METHOD = 0;
        private static final int ENCOUNTERED_NATIVE_TYPE = 1;
        private static final int ENCOUNTERED_NATIVE_COLLECTION_TYPE = 2;
        private static final int ENCOUNTERED_CONFIGURED_TYPE = 3;
        private static final int ENCOUNTERED_JAVA_OBJECT = 4;
        private static final int ENCOUNTERED_ALREADY_CACHED_IMMUTABLE = 5;
        private static final int ENCOUNTERED_WRONG_TYPE = 6;
        private static final int ENCOUNTERED_WRONG_NAME = 7;
        private static final int EXPECTING_ROOT = 0;
        private static final int EXPECTING_TO_CONFIGURE = 1;
        private static final int EXPECTING_OBJECT = 2;
        private static final int EXPECTING_METHOD = 3;
        private Object mToConfigure;
        private String[] mNames;
        private int mLocationIndex;
        private Map<Integer, Object> mImmutableForThisLocationCache;
        private int mDepth;
        private int mIgnoreTypeAfterDepth = -1;
        private int mIgnoreNameAfterDepth = -1;
        private int mIgnoreImmutableAfterDepth = -1;
        private Stack<Object> mConstructing = CollectionUtils.newStack();
        private int mExpecting = 0;
        private Stack<Integer> mEncountered = CollectionUtils.newStack();
        private StringBuffer mBufferValue;
        private XmlUtils.CachingContentHandler mCachingContentHandler;

        public ConfigHandler(Object object, String[] stringArray) {
            this.mToConfigure = object;
            this.mNames = stringArray;
        }

        public void setImmutableForThisLocationCache(Map<Integer, Object> map) {
            this.mImmutableForThisLocationCache = map;
        }

        public void setCachingContentHandler(XmlUtils.CachingContentHandler cachingContentHandler) {
            this.mCachingContentHandler = cachingContentHandler;
        }

        public Object getConfigured() {
            if (this.mConstructing.isEmpty()) {
                throw MetawidgetException.newException(new StringBuffer().append("No match for ").append(this.mToConfigure).append(" within config").toString());
            }
            if (this.mConstructing.size() > 1) {
                throw MetawidgetException.newException("Config still processing");
            }
            return this.mConstructing.peek();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1 && this.mDepth > this.mIgnoreTypeAfterDepth) {
                return;
            }
            if (this.mIgnoreNameAfterDepth != -1 && this.mDepth > this.mIgnoreNameAfterDepth) {
                return;
            }
            if (Character.isUpperCase(string2.charAt(0))) {
                throw MetawidgetException.newException(new StringBuffer().append("XML node '").append(string2).append("' should start with a lowercase letter").toString());
            }
            try {
                switch (this.mExpecting) {
                    case 0: {
                        if (this.mToConfigure == null) {
                            this.mExpecting = 2;
                            break;
                        }
                        this.mExpecting = 1;
                        break;
                    }
                    case 1: {
                        if (this.mDepth != 2) {
                            return;
                        }
                        Class<?> clazz = this.classForName(string, string2);
                        if (this.mToConfigure instanceof Class) {
                            if (!((Class)this.mToConfigure).isAssignableFrom(clazz)) {
                                this.mEncountered.push(new Integer(6));
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException(new StringBuffer().append("Already configured a ").append(this.mConstructing.peek().getClass()).append(", ambiguous match with ").append(clazz).toString());
                            }
                            this.handleNonNativeObject(string, string2, attributes);
                        } else {
                            if (!clazz.isAssignableFrom(this.mToConfigure.getClass())) {
                                this.mEncountered.push(new Integer(6));
                                this.mIgnoreTypeAfterDepth = 2;
                                if (this.mCachingContentHandler != null) {
                                    this.mCachingContentHandler.pause(false);
                                }
                                return;
                            }
                            if (!this.mConstructing.isEmpty()) {
                                throw MetawidgetException.newException(new StringBuffer().append("Already configured a ").append(this.mConstructing.peek().getClass()).append(", ambiguous match with ").append(clazz).toString());
                            }
                            this.mConstructing.push(this.mToConfigure);
                            this.mEncountered.push(new Integer(4));
                        }
                        this.mExpecting = 3;
                        break;
                    }
                    case 2: {
                        if (this.mCachingContentHandler == null || !this.mCachingContentHandler.isPaused()) {
                            ++this.mLocationIndex;
                        }
                        if (ConfigReader.this.isNative(string2) || ConfigReader.this.isLazyResolvingNative(string2)) {
                            this.mEncountered.push(new Integer(1));
                            this.startRecording();
                            this.mExpecting = 3;
                            return;
                        }
                        Object object = ConfigReader.this.createNativeCollection(string2);
                        if (object != null) {
                            this.mConstructing.push(object);
                            this.mEncountered.push(new Integer(2));
                            this.mExpecting = 2;
                            return;
                        }
                        if (this.isJdk14Hack(string, string2)) {
                            this.mEncountered.push(new Integer(6));
                            this.mExpecting = 2;
                            return;
                        }
                        this.handleNonNativeObject(string, string2, attributes);
                        this.mExpecting = 3;
                        break;
                    }
                    case 3: {
                        String string4;
                        int n;
                        if (this.mNames != null && (n = this.mDepth - 3) < this.mNames.length && !string2.equals(string4 = this.mNames[n])) {
                            this.mEncountered.push(new Integer(7));
                            this.mIgnoreNameAfterDepth = this.mDepth;
                            if (this.mCachingContentHandler != null) {
                                this.mCachingContentHandler.pause(false);
                            }
                            return;
                        }
                        this.mConstructing.push(new ArrayList());
                        this.mEncountered.push(new Integer(0));
                        this.mExpecting = 2;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }

        public void startRecording() {
            this.mBufferValue = new StringBuffer();
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this.mBufferValue == null) {
                return;
            }
            this.mBufferValue.append(cArray, n, n2);
        }

        public String endRecording() {
            String string = this.mBufferValue.toString();
            this.mBufferValue = null;
            return string;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.mDepth;
            if (this.mIgnoreTypeAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreTypeAfterDepth) {
                    return;
                }
                this.mIgnoreTypeAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mIgnoreNameAfterDepth != -1) {
                if (this.mDepth >= this.mIgnoreNameAfterDepth) {
                    return;
                }
                this.mIgnoreNameAfterDepth = -1;
                if (this.mCachingContentHandler != null) {
                    this.mCachingContentHandler.unpause(false);
                }
            }
            if (this.mDepth == 0) {
                return;
            }
            if (this.mConstructing.isEmpty()) {
                return;
            }
            try {
                int n = this.mEncountered.pop();
                switch (n) {
                    case 1: {
                        Object object = this.mConstructing.pop();
                        Object object2 = this.mConstructing.peek();
                        this.mConstructing.push(object);
                        this.addToConstructing(ConfigReader.this.createNative(string2, object2.getClass(), this.endRecording()));
                        this.mExpecting = 2;
                        return;
                    }
                    case 2: {
                        Object object = this.mConstructing.pop();
                        Collection collection = (Collection)this.mConstructing.peek();
                        collection.add(object);
                        this.mExpecting = 2;
                        return;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        Object object = this.mConstructing.pop();
                        if (n == 3) {
                            Class<?> clazz = this.classForName(string, string2);
                            Object object3 = null;
                            if (ConfigReader.this.isImmutable(clazz)) {
                                object3 = this.getImmutableByClass(clazz, object);
                            }
                            if (object3 == null) {
                                try {
                                    Constructor<?> constructor = clazz.getConstructor(object.getClass());
                                    object3 = constructor.newInstance(object);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    String string4 = this.getLikelyConfig(clazz);
                                    if ("".equals(string4)) {
                                        throw MetawidgetException.newException(new StringBuffer().append(clazz).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute. It only has a config-less constructor").toString());
                                    }
                                    if (string4 != null) {
                                        throw MetawidgetException.newException(new StringBuffer().append(clazz).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute. Did you mean config=\"").append(string4).append("\"?").toString());
                                    }
                                    throw MetawidgetException.newException(new StringBuffer().append(clazz).append(" does not have a constructor that takes a ").append(object.getClass()).append(", as specified by your config attribute").toString());
                                }
                                if (ConfigReader.this.isImmutable(clazz)) {
                                    LOG.debug(new StringBuffer().append("\tInstantiated immutable ").append(clazz).append(" (config hashCode ").append(object.hashCode()).append(")").toString());
                                    this.putImmutableByClass(object3, object);
                                }
                            } else if (ConfigReader.this.isImmutable(clazz) && this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                                this.mCachingContentHandler.unpause(true);
                                this.mIgnoreImmutableAfterDepth = -1;
                                this.putImmutableByLocation(object3);
                            }
                            object = object3;
                        }
                        if (this.mDepth == 1) {
                            this.mConstructing.push(object);
                            this.mExpecting = 1;
                            return;
                        }
                        this.addToConstructing(object);
                        this.mExpecting = 2;
                        return;
                    }
                    case 0: {
                        List list = (List)this.mConstructing.pop();
                        Object object = this.mConstructing.peek();
                        Class<?> clazz = object.getClass();
                        String string5 = new StringBuffer().append("set").append(StringUtils.uppercaseFirstLetter(string2)).toString();
                        try {
                            Method method = this.classGetMethod(clazz, string5, list);
                            method.invoke(object, list.toArray());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            for (Constructor<?> constructor : clazz.getConstructors()) {
                                String string6;
                                Class<?>[] classArray = constructor.getParameterTypes();
                                if (classArray.length != 1 || !(string6 = ClassUtils.getSimpleName(classArray[0].getClass())).endsWith("Config")) continue;
                                throw MetawidgetException.newException(new StringBuffer().append("No such method ").append(string5).append(" on ").append(clazz).append(". Did you forget config=\"").append(string6).append("\"?").toString());
                            }
                            throw noSuchMethodException;
                        }
                        this.mExpecting = 3;
                        return;
                    }
                    case 6: {
                        return;
                    }
                    case 7: {
                        return;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                Exception exception2;
                if (exception instanceof InvocationTargetException) {
                    Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    if (!(throwable instanceof Exception)) {
                        throw new RuntimeException(throwable);
                    }
                    exception2 = (Exception)throwable;
                }
                throw new SAXException(exception2);
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            LOG.warn(sAXParseException.getMessage());
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            throw MetawidgetException.newException(sAXParseException);
        }

        private void handleNonNativeObject(String string, String string2, Attributes attributes) throws Exception {
            Object object;
            Class<?> clazz = this.classForName(string, string2);
            Object object2 = null;
            if (ConfigReader.this.isImmutable(clazz)) {
                object2 = this.getImmutableByLocation(clazz);
            }
            if (object2 == null && (object = attributes.getValue("config")) != null) {
                Object object3 = ((String)object).indexOf(46) == -1 ? new StringBuffer().append(clazz.getPackage().getName()).append('.').append((String)object).toString() : object;
                Class<?> clazz2 = ClassUtils.niceForName((String)object3, this.getClass().getClassLoader());
                if (clazz2 == null) {
                    throw MetawidgetException.newException(new StringBuffer().append("No such configuration class ").append((String)object3).toString());
                }
                Object obj = clazz2.newInstance();
                if (obj instanceof NeedsResourceResolver) {
                    ((NeedsResourceResolver)obj).setResourceResolver(ConfigReader.this);
                }
                this.mConstructing.push(obj);
                this.mEncountered.push(new Integer(3));
                if (this.mIgnoreImmutableAfterDepth == -1 && this.mCachingContentHandler != null && ConfigReader.this.isImmutable(clazz)) {
                    this.mCachingContentHandler.pause(true);
                    this.mIgnoreImmutableAfterDepth = this.mDepth;
                }
                this.mExpecting = 3;
                return;
            }
            if (object2 == null && ConfigReader.this.isImmutable(clazz)) {
                object2 = this.getImmutableByClass(clazz, ConfigReader.IMMUTABLE_NO_CONFIG);
            }
            if (object2 == null) {
                try {
                    object = clazz.getConstructor(new Class[0]);
                    object2 = ((Constructor)object).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    String string3 = this.getLikelyConfig(clazz);
                    if (string3 != null) {
                        throw MetawidgetException.newException(new StringBuffer().append(clazz).append(" does not have a default constructor. Did you mean config=\"").append(string3).append("\"?").toString());
                    }
                    throw MetawidgetException.newException(new StringBuffer().append(clazz).append(" does not have a default constructor").toString());
                }
                if (ConfigReader.this.isImmutable(clazz)) {
                    LOG.debug(new StringBuffer().append("\tInstantiated immutable ").append(clazz).append(" (no config)").toString());
                    this.putImmutableByClass(object2, null);
                }
            }
            this.mConstructing.push(object2);
            this.mEncountered.push(new Integer(4));
        }

        private void addToConstructing(Object object) {
            Object object2 = this.mConstructing.peek();
            if (object2 instanceof Collection) {
                Collection collection = (Collection)object2;
                collection.add(object);
                return;
            }
            if (object2.getClass().isArray()) {
                Object[] objectArray = (Object[])this.mConstructing.pop();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray.length] = object;
                this.mConstructing.push(objectArray2);
                return;
            }
            throw MetawidgetException.newException(new StringBuffer().append("Don't know how to add to a ").append(object2.getClass()).toString());
        }

        private Object getImmutableByLocation(Class<?> clazz) {
            if (this.mImmutableForThisLocationCache == null) {
                return null;
            }
            return this.mImmutableForThisLocationCache.get(new Integer(this.mLocationIndex));
        }

        private void putImmutableByLocation(Object object) {
            if (this.mImmutableForThisLocationCache == null) {
                return;
            }
            this.mImmutableForThisLocationCache.put(new Integer(this.mLocationIndex), object);
        }

        private Object getImmutableByClass(Class<?> clazz, Object object) {
            Map<Object, Object> map = ConfigReader.this.mImmutableByClassCache.get(clazz);
            if (map == null) {
                return null;
            }
            Object object2 = object;
            if (object2 == null) {
                object2 = ConfigReader.IMMUTABLE_NO_CONFIG;
            }
            return map.get(object2);
        }

        private void putImmutableByClass(Object object, Object object2) {
            Object object3;
            Map<Object, Object> map;
            block12: {
                Class<?> clazz = object.getClass();
                map = ConfigReader.this.mImmutableByClassCache.get(clazz);
                if (map == null) {
                    map = CollectionUtils.newHashMap();
                    ConfigReader.this.mImmutableByClassCache.put(clazz, map);
                }
                if ((object3 = object2) == null) {
                    object3 = ConfigReader.IMMUTABLE_NO_CONFIG;
                } else {
                    try {
                        Class<?> clazz2;
                        Class<?> clazz3 = object3.getClass();
                        Class<?> clazz4 = clazz3.getMethod("equals", class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).getDeclaringClass();
                        if ((class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).equals(clazz4)) {
                            throw MetawidgetException.newException(new StringBuffer().append(clazz3).append(" does not override .equals(), so cannot cache reliably").toString());
                        }
                        if ((class$java$lang$Object == null ? (class$java$lang$Object = ConfigReader.class$("java.lang.Object")) : class$java$lang$Object).equals(clazz2 = clazz3.getMethod("hashCode", new Class[0]).getDeclaringClass())) {
                            throw MetawidgetException.newException(new StringBuffer().append(clazz3).append(" does not override .hashCode(), so cannot cache reliably").toString());
                        }
                        if (System.identityHashCode(object3) == object3.hashCode()) {
                            LOG.warn(new StringBuffer().append(clazz3).append(" overrides .hashCode(), but it returns the same as System.identityHashCode, so cannot be cached reliably").toString());
                        }
                        if (!clazz4.equals(clazz2)) {
                            throw MetawidgetException.newException(new StringBuffer().append(clazz4).append(" implements .equals(), but .hashCode() is implemented by ").append(clazz2).append(", so cannot cache reliably").toString());
                        }
                        if (clazz3.equals(clazz4)) break block12;
                        for (Method method : clazz3.getMethods()) {
                            if (!clazz3.equals(method.getDeclaringClass())) continue;
                            LOG.warn(new StringBuffer().append(clazz3).append(" does not override .equals() (only its super").append(clazz4).append(" does), so may not be cached reliably").toString());
                            break;
                        }
                    }
                    catch (Exception exception) {
                        throw MetawidgetException.newException(exception);
                    }
                }
            }
            map.put(object3, object);
            if (this.mCachingContentHandler != null && this.mDepth < this.mIgnoreImmutableAfterDepth) {
                this.mCachingContentHandler.unpause(true);
                this.mIgnoreImmutableAfterDepth = -1;
                if (object2 != null) {
                    this.putImmutableByLocation(object);
                }
            }
        }

        protected boolean isJdk14Hack(String string, String string2) {
            if (!"java:org.metawidget.inspector.annotation".equals(string)) {
                return false;
            }
            if (!"metawidgetAnnotationInspector".equals(string2)) {
                return false;
            }
            try {
                ClassUtils.niceForName("org.metawidget.inspector.annotation.MetawidgetAnnotationInspector", this.getClass().getClassLoader());
                return false;
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                LOG.debug("\tNot instantiating org.metawidget.inspector.annotation.MetawidgetAnnotationInspector - wrong Java version");
                return true;
            }
        }

        private Class<?> classForName(String string, String string2) throws SAXException {
            if (!string.startsWith(JAVA_NAMESPACE_PREFIX)) {
                throw new SAXException(new StringBuffer().append("Namespace '").append(string).append("' of element <").append(string2).append("> must start with ").append(JAVA_NAMESPACE_PREFIX).toString());
            }
            String string3 = new StringBuffer().append(string.substring(JAVA_NAMESPACE_PREFIX.length())).append('.').toString();
            String string4 = new StringBuffer().append(string3).append(StringUtils.uppercaseFirstLetter(string2)).toString();
            Class<?> clazz = ClassUtils.niceForName(string4, this.getClass().getClassLoader());
            if (clazz == null) {
                throw MetawidgetException.newException(new StringBuffer().append("No such class ").append(string4).append(" or supported tag <").append(string2).append(">").toString());
            }
            return clazz;
        }

        private Method classGetMethod(Class<?> clazz, String string, List<Object> list) throws NoSuchMethodException {
            int n = list.size();
            Method method = null;
            block0: for (Method method2 : clazz.getMethods()) {
                if (!method2.getName().equals(string)) continue;
                method = method2;
                Class<?>[] classArray = method2.getParameterTypes();
                if (classArray.length != n) continue;
                ArrayList<Object> arrayList = CollectionUtils.newArrayList(list);
                for (int i = 0; i < n; ++i) {
                    Object e = arrayList.get(i);
                    Class<?> clazz2 = classArray[i];
                    if (clazz2.isPrimitive()) {
                        clazz2 = ClassUtils.getWrapperClass(clazz2);
                    } else if (e == null) continue;
                    if (clazz2.isInstance(e)) continue;
                    Object object = ConfigReader.this.createLazyResolvingNative(e, clazz2);
                    if (object == null) continue block0;
                    arrayList.remove(i);
                    arrayList.add(i, object);
                }
                list.clear();
                list.addAll(arrayList);
                return method2;
            }
            if (method != null) {
                throw new NoSuchMethodException(new StringBuffer().append(this.methodToString(clazz, string, list)).append(". Did you mean ").append(this.methodToString(method)).append("?").toString());
            }
            throw new NoSuchMethodException(this.methodToString(clazz, string, list));
        }

        private String getLikelyConfig(Class<?> clazz) {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            if (constructorArray.length != 1) {
                return null;
            }
            if (constructorArray[0].getParameterTypes().length == 0) {
                return "";
            }
            if (constructorArray[0].getParameterTypes().length > 1) {
                return null;
            }
            Class<?> clazz2 = constructorArray[0].getParameterTypes()[0];
            if (clazz2.getPackage().equals(clazz.getPackage())) {
                return ClassUtils.getSimpleName(clazz2);
            }
            return clazz2.getName();
        }

        private String methodToString(Method method) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Class<?> clazz : method.getParameterTypes()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ClassUtils.getSimpleName(clazz));
            }
            stringBuffer.insert(0, "(");
            stringBuffer.insert(0, method.getName());
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        private String methodToString(Class<?> clazz, String string, List<Object> list) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                if (object == null) {
                    stringBuffer.append("null");
                    continue;
                }
                stringBuffer.append(ClassUtils.getSimpleName(object.getClass()));
            }
            stringBuffer.insert(0, "(");
            stringBuffer.insert(0, string);
            stringBuffer.insert(0, '.');
            stringBuffer.insert(0, clazz);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

