/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.metawidget.config.ConfigReader;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.util.IOUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSchemaGeneratorTask
extends Task {
    private static final String CLASS_SUFFIX = ".class";
    private static final String XSD_SUFFIX = "-1.0.xsd";
    private static final String SCHEMA_END = "\r\n</xs:schema>";
    private String mJar;
    private String mDestDir;
    static /* synthetic */ Class class$org$metawidget$jsp$tagext$MetawidgetTag;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$metawidget$config$ResourceResolver;
    static /* synthetic */ Class class$java$util$ResourceBundle;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public void setJar(String string) {
        this.mJar = string;
    }

    public void setDestDir(String string) {
        this.mDestDir = string;
    }

    public void execute() throws BuildException {
        try {
            File file = new File(this.mDestDir);
            file.mkdirs();
            for (File object2 : file.listFiles()) {
                if (object2.isDirectory()) continue;
                object2.delete();
            }
            FileWriter fileWriter = new FileWriter(new File(file, "index.html"));
            fileWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n");
            fileWriter.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\r\n");
            fileWriter.write("\t<head>\r\n");
            fileWriter.write("\t\t<title>Metawidget XML Schemas</title>");
            fileWriter.write("\t</head>\r\n");
            fileWriter.write("\t<body>\r\n");
            fileWriter.write("\t\t<h1>Metawidget XML Schemas</h1>\r\n");
            fileWriter.write("\t\t<h2>Inspection Results</h2>\r\n");
            fileWriter.write("\t\t<p>This schema is used for inspection results returned by <a href=\"http://metawidget.org/doc/api/org/metawidget/inspector/iface/Inspector.html\">Inspectors</a>:</p>\r\n");
            fileWriter.write("\t\t<ul>\r\n");
            fileWriter.write("\t\t\t<li><a href=\"inspection-result-1.0.xsd\">inspection-result-1.0.xsd</a></li>\r\n");
            fileWriter.write("\t\t</ul>\r\n");
            fileWriter.write("\t\t<h2>External Configuration</h2>\r\n");
            fileWriter.write("\t\t<p>These schemas are (optionally) used when externally configuring Metawidget via <tt>metawidget.xml</tt>. For example</p>\r\n");
            fileWriter.write("<div style=\"background-color: #eeeeee; border: 1px solid #cccccc; padding: 5px\"><tt>&lt;metawidget xmlns=\"<strong>http://metawidget.org</strong>\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"<br/>");
            fileWriter.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;xsi:schemaLocation=\"<strong>http://metawidget.org http://metawidget.org/xsd/metawidget-1.0.xsd<br/>");
            fileWriter.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;java:org.metawidget.jsp.tagext.html.spring http://metawidget.org/xsd/org.metawidget.jsp.tagext.html.spring-1.0.xsd</strong>\"<br/>");
            fileWriter.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;version=\"1.0\"&gt;<br/>");
            fileWriter.write("&nbsp;&nbsp;&nbsp;&lt;springMetawidgetTag xmlns=\"<strong>java:org.metawidget.jsp.tagext.html.spring</strong>\"/&gt;<br/>");
            fileWriter.write("&lt;/metawidget&gt;</tt></div>\r\n");
            fileWriter.write("\t\t<ul>\r\n");
            fileWriter.write("\t\t\t<li><a href=\"metawidget-1.0.xsd\">metawidget-1.0.xsd</a></li>\r\n");
            JarFile jarFile = new JarFile(this.mJar);
            String string = null;
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                int byteArrayOutputStream;
                String string3;
                String string4;
                int n;
                String string5;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(string5 = jarEntry.getName()).endsWith(CLASS_SUFFIX) || (n = (string4 = string5.replace('/', '.').substring(0, string5.length() - CLASS_SUFFIX.length())).lastIndexOf(46)) == -1 || (string3 = string4.substring(n + 1)).contains("$")) continue;
                String string6 = string4.substring(0, n);
                File file2 = new File(file, new StringBuffer().append(string6).append(XSD_SUFFIX).toString());
                StringBuilder stringBuilder = new StringBuilder();
                if (file2.exists()) {
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    IOUtils.streamBetween(new FileInputStream(file2), byteArrayOutputStream2);
                    stringBuilder.append(byteArrayOutputStream2.toString());
                } else {
                    stringBuilder.append("<?xml version=\"1.0\" ?>\r\n");
                    stringBuilder.append("<xs:schema targetNamespace=\"java:");
                    stringBuilder.append(string6);
                    stringBuilder.append("\" xmlns=\"java:");
                    stringBuilder.append(string6);
                    stringBuilder.append("\"");
                    stringBuilder.append(" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\" version=\"1.0\">\r\n");
                    stringBuilder.append(SCHEMA_END);
                }
                if ((byteArrayOutputStream = stringBuilder.indexOf(SCHEMA_END)) == -1 || (string2 = this.generateClassBlock(string6, string3)) == null) continue;
                stringBuilder.insert(byteArrayOutputStream, string2);
                IOUtils.streamBetween(new ByteArrayInputStream(stringBuilder.toString().getBytes()), new FileOutputStream(file2));
                String string7 = file2.getName();
                if (string7.equals(string)) continue;
                fileWriter.write(new StringBuffer().append("\t\t\t<li><a href=\"").append(string7).append("\">").append(string7).append("</a></li>\r\n").toString());
                string = string7;
            }
            jarFile.close();
            fileWriter.write("\t\t</ul>\r\n\t</body>\r\n</html>");
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    String generateClassBlock(String string, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\r\n\t<!-- ");
        stringBuilder.append(string2);
        stringBuilder.append(" -->\r\n");
        stringBuilder.append("\r\n");
        stringBuilder.append("\t<xs:element name=\"");
        stringBuilder.append(StringUtils.lowercaseFirstLetter(string2));
        stringBuilder.append("\">\r\n");
        stringBuilder.append("\t\t<xs:complexType>\r\n");
        Class<?> clazz = Class.forName(new StringBuffer().append(string).append('.').append(string2).toString());
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return null;
        }
        if (!(new ConfigReader().isImmutable(clazz) || string2.endsWith("Metawidget") || (class$org$metawidget$jsp$tagext$MetawidgetTag == null ? (class$org$metawidget$jsp$tagext$MetawidgetTag = XmlSchemaGeneratorTask.class$("org.metawidget.jsp.tagext.MetawidgetTag")) : class$org$metawidget$jsp$tagext$MetawidgetTag).isAssignableFrom(clazz))) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?> clazz2;
            if (constructor.getParameterTypes().length == 0) {
                bl2 = true;
                continue;
            }
            if (constructor.getParameterTypes().length > 1 || !(clazz2 = constructor.getParameterTypes()[0]).getName().endsWith("Config")) continue;
            clazz = clazz2;
            bl = true;
        }
        String string3 = this.generatePropertiesBlock(clazz);
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append("\t\t\t<xs:attribute name=\"config\" type=\"xs:string\"");
        if (!bl) {
            stringBuilder.append(" use=\"prohibited\"");
        } else if (!bl2) {
            stringBuilder.append(" use=\"required\"");
        }
        stringBuilder.append("/>\r\n");
        stringBuilder.append("\t\t</xs:complexType>\r\n");
        stringBuilder.append("\t</xs:element>\r\n\r\n");
        return stringBuilder.toString();
    }

    private String generatePropertiesBlock(Class<?> clazz) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        try {
            clazz.getMethod("setParameter", class$java$lang$String == null ? (class$java$lang$String = XmlSchemaGeneratorTask.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = XmlSchemaGeneratorTask.class$("java.lang.Object")) : class$java$lang$Object);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            stringBuilder.append("\t\t\t<xs:sequence>\r\n");
            stringBuilder.append(this.generatePropertyBlock("parameter", true, new Class[]{class$java$lang$String == null ? (class$java$lang$String = XmlSchemaGeneratorTask.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = XmlSchemaGeneratorTask.class$("java.lang.Object")) : class$java$lang$Object}));
        } else {
            stringBuilder.append("\t\t\t<xs:all>\r\n");
        }
        boolean bl2 = false;
        BasePropertyStyleConfig basePropertyStyleConfig = new BasePropertyStyleConfig();
        basePropertyStyleConfig.setExcludeBaseType(Pattern.compile("^(java|javax|org\\.eclipse)\\..*$"));
        JavaBeanPropertyStyle javaBeanPropertyStyle = new JavaBeanPropertyStyle(basePropertyStyleConfig);
        Map<String, Property> map = javaBeanPropertyStyle.getProperties(clazz);
        for (Property property : map.values()) {
            String string;
            if (!property.isWritable() || "config".equals(property.getName()) || (string = this.generatePropertyBlock(property.getName(), false, new Class[]{property.getType()})) == null) continue;
            bl2 = true;
            stringBuilder.append(string);
        }
        if (!bl2) {
            return null;
        }
        if (bl) {
            stringBuilder.append("\t\t\t</xs:sequence>\r\n");
        } else {
            stringBuilder.append("\t\t\t</xs:all>\r\n");
        }
        return stringBuilder.toString();
    }

    private String generatePropertyBlock(String string, boolean bl, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t\t\t\t<xs:element name=\"");
        stringBuilder.append(string);
        stringBuilder.append("\" minOccurs=\"0\"");
        if (bl) {
            stringBuilder.append(" maxOccurs=\"unbounded\"");
        }
        stringBuilder.append(">\r\n");
        stringBuilder.append("\t\t\t\t\t<xs:complexType>\r\n");
        stringBuilder.append("\t\t\t\t\t\t<xs:sequence>\r\n");
        for (Class<?> clazz : classArray) {
            String string2 = this.generateTypeBlock(clazz);
            if (string2 == null) {
                return null;
            }
            stringBuilder.append(string2);
        }
        stringBuilder.append("\t\t\t\t\t\t</xs:sequence>\r\n");
        stringBuilder.append("\t\t\t\t\t</xs:complexType>\r\n");
        stringBuilder.append("\t\t\t\t</xs:element>\r\n");
        return stringBuilder.toString();
    }

    private String generateTypeBlock(Class<?> clazz) {
        if ((class$org$metawidget$config$ResourceResolver == null ? (class$org$metawidget$config$ResourceResolver = XmlSchemaGeneratorTask.class$("org.metawidget.config.ResourceResolver")) : class$org$metawidget$config$ResourceResolver).equals(clazz)) {
            return null;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return "\t\t\t\t\t\t\t<xs:element name=\"boolean\" type=\"xs:boolean\"/>\r\n";
        }
        if (Integer.TYPE.equals(clazz)) {
            return "\t\t\t\t\t\t\t<xs:element name=\"int\" type=\"xs:int\"/>\r\n";
        }
        if ((class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = XmlSchemaGeneratorTask.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle).equals(clazz)) {
            return "\t\t\t\t\t\t\t<xs:element name=\"bundle\" type=\"xs:string\"/>\r\n";
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = XmlSchemaGeneratorTask.class$("java.lang.String")) : class$java$lang$String).equals(clazz)) {
            return "\t\t\t\t\t\t\t<xs:element name=\"string\" type=\"xs:string\"/>\r\n";
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = XmlSchemaGeneratorTask.class$("java.io.InputStream")) : class$java$io$InputStream).equals(clazz)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\t\t\t\t\t\t\t<xs:choice>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t<xs:element name=\"file\" type=\"xs:string\"/>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t<xs:element name=\"resource\" type=\"xs:string\"/>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t<xs:element name=\"url\" type=\"xs:anyURI\"/>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t</xs:choice>\r\n");
            return stringBuilder.toString();
        }
        if (clazz.isArray() || (class$java$util$List == null ? (class$java$util$List = XmlSchemaGeneratorTask.class$("java.util.List")) : class$java$util$List).equals(clazz) || (class$java$util$Set == null ? (class$java$util$Set = XmlSchemaGeneratorTask.class$("java.util.Set")) : class$java$util$Set).equals(clazz)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\t\t\t\t\t\t\t<xs:element name=\"");
            if (clazz.isArray()) {
                stringBuilder.append("array");
            } else if ((class$java$util$List == null ? (class$java$util$List = XmlSchemaGeneratorTask.class$("java.util.List")) : class$java$util$List).equals(clazz)) {
                stringBuilder.append("list");
            } else if ((class$java$util$Set == null ? (class$java$util$Set = XmlSchemaGeneratorTask.class$("java.util.Set")) : class$java$util$Set).equals(clazz)) {
                stringBuilder.append("set");
            }
            stringBuilder.append("\">\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t<xs:complexType>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t\t<xs:sequence>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t\t\t<xs:any maxOccurs=\"unbounded\" processContents=\"lax\"/>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t\t</xs:sequence>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t\t</xs:complexType>\r\n");
            stringBuilder.append("\t\t\t\t\t\t\t</xs:element>\r\n");
            return stringBuilder.toString();
        }
        return "\t\t\t\t\t\t\t<xs:any processContents=\"lax\"/>\r\n";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

