/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces;

import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;

public final class FacesUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("((#|\\$)\\{)(.*)(\\})");
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";

    public static boolean isExpression(String string) {
        return PATTERN_EXPRESSION.matcher(string).matches();
    }

    public static String unwrapExpression(String string) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        return matcher.group(3);
    }

    public static String wrapExpression(String string) {
        if (FacesUtils.isExpression(string)) {
            return string;
        }
        return EXPRESSION_START + FacesUtils.unwrapExpression(string) + EXPRESSION_END;
    }

    public static UIComponent findRenderedComponentWithValueBinding(UIComponent uIComponent, String string) {
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            ValueBinding valueBinding = uIComponent2.getValueBinding("value");
            if (valueBinding == null || !string.equals(valueBinding.getExpressionString()) || !uIComponent2.isRendered()) continue;
            return uIComponent2;
        }
        return null;
    }

    public static UIComponent findRenderedComponentWithMethodBinding(UIComponent uIComponent, String string) {
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            MethodBinding methodBinding;
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            if (!(uIComponent2 instanceof ActionSource) || (methodBinding = ((ActionSource)uIComponent2).getAction()) == null || !string.equals(methodBinding.getExpressionString()) || !uIComponent2.isRendered()) continue;
            return uIComponent2;
        }
        return null;
    }

    public static UIParameter findParameterWithName(UIComponent uIComponent, String string) {
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIParameter uIParameter;
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            if (!(uIComponent2 instanceof UIParameter) || !string.equals((uIParameter = (UIParameter)uIComponent2).getName())) continue;
            return uIParameter;
        }
        return null;
    }

    public static void render(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        if (uIComponent == null || !uIComponent.isRendered()) {
            return;
        }
        uIComponent.encodeBegin(facesContext);
        if (uIComponent.getRendersChildren()) {
            uIComponent.encodeChildren(facesContext);
        } else {
            FacesUtils.renderChildren(facesContext, uIComponent);
        }
        uIComponent.encodeEnd(facesContext);
    }

    public static void copyParameters(UIComponent uIComponent, UIComponent uIComponent2) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent3 = (UIComponent)iterator.next();
            if (!(uIComponent3 instanceof UIParameter)) continue;
            UIParameter uIParameter = (UIParameter)application.createComponent("javax.faces.Parameter");
            uIParameter.setId(uIViewRoot.createUniqueId());
            UIParameter uIParameter2 = (UIParameter)uIComponent3;
            uIParameter.setName(uIParameter2.getName());
            uIParameter.setValue(uIParameter2.getValue());
            uIComponent2.getChildren().add(uIParameter);
        }
    }

    private static void renderChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent uIComponent2 = (UIComponent)iterator.next();
            FacesUtils.render(facesContext, uIComponent2);
        }
    }

    private FacesUtils() {
    }
}

