/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.jexl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.metawidget.inspector.commons.jexl.UiJexlAttribute;
import org.metawidget.inspector.commons.jexl.UiJexlAttributes;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.ThreadUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlInspector
extends BaseObjectInspector {
    private static final ThreadLocal<Object> LOCAL_TOINSPECT = ThreadUtils.newThreadLocal();
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = ThreadUtils.newThreadLocal();

    public JexlInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public JexlInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> inspectParent(Object object, Property property) throws Exception {
        try {
            LOCAL_TOINSPECT.set(object);
            Map<String, String> map = super.inspectParent(object, property);
            return map;
        }
        finally {
            LOCAL_CONTEXT.remove();
            LOCAL_TOINSPECT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void inspect(Object object, Class<?> clazz, Element element) throws Exception {
        try {
            LOCAL_TOINSPECT.set(object);
            super.inspect(object, clazz, element);
        }
        finally {
            LOCAL_CONTEXT.remove();
            LOCAL_TOINSPECT.remove();
        }
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        this.putJexlAttributes(hashMap, trait.getAnnotation(UiJexlAttributes.class), trait.getAnnotation(UiJexlAttribute.class));
        return hashMap;
    }

    protected void putJexlAttributes(Map<String, String> map, UiJexlAttributes uiJexlAttributes, UiJexlAttribute uiJexlAttribute) throws Exception {
        if (uiJexlAttribute != null) {
            this.putJexlAttribute(uiJexlAttribute, map);
        }
        if (uiJexlAttributes != null) {
            for (UiJexlAttribute uiJexlAttribute2 : uiJexlAttributes.value()) {
                this.putJexlAttribute(uiJexlAttribute2, map);
            }
        }
    }

    protected void putJexlAttribute(UiJexlAttribute uiJexlAttribute, Map<String, String> map) throws Exception {
        String string = uiJexlAttribute.expression();
        if (string.startsWith("${")) {
            throw InspectorException.newException("Expression '" + string + "' should be of the form 'foo.bar', not '${foo.bar}'");
        }
        Object object = ExpressionFactory.createExpression((String)string).evaluate(this.getContext());
        if (object == null) {
            return;
        }
        map.put(uiJexlAttribute.name(), StringUtils.quietValueOf(object));
    }

    protected JexlContext getContext() {
        JexlContext jexlContext = LOCAL_CONTEXT.get();
        if (jexlContext == null) {
            jexlContext = this.createContext(LOCAL_TOINSPECT.get());
            LOCAL_CONTEXT.set(jexlContext);
        }
        return jexlContext;
    }

    protected JexlContext createContext(Object object) {
        JexlContext jexlContext = JexlHelper.createContext();
        Map map = jexlContext.getVars();
        if (object != null) {
            map.put("this", object);
        }
        return jexlContext;
    }
}

