/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.composite;

import org.metawidget.inspector.composite.CompositeInspectorConfig;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;

public class CompositeInspector
implements Inspector {
    private static final LogUtils.Log LOG = LogUtils.getLog(CompositeInspector.class);
    final Inspector[] mInspectors;

    public CompositeInspector(CompositeInspectorConfig compositeInspectorConfig) {
        Inspector[] inspectorArray = compositeInspectorConfig.getInspectors();
        if (inspectorArray == null || inspectorArray.length == 0) {
            throw InspectorException.newException("CompositeInspector needs at least one Inspector");
        }
        this.mInspectors = new Inspector[inspectorArray.length];
        System.arraycopy(inspectorArray, 0, this.mInspectors, 0, inspectorArray.length);
    }

    public String inspect(Object object, String string, String[] stringArray) {
        return this.inspect(null, object, string, stringArray);
    }

    public String inspect(String string, Object object, String string2, String[] stringArray) {
        try {
            Document document = XmlUtils.documentFromString(string);
            Object object2 = this.mInspectors;
            int n = ((Inspector[])object2).length;
            for (int i = 0; i < n; ++i) {
                Inspector inspector = object2[i];
                String string3 = inspector.inspect(object, string2, stringArray);
                if (string3 == null) continue;
                Document document2 = this.parseInspectionResult(string3);
                if (LOG.isTraceEnabled()) {
                    String string4 = XmlUtils.documentToString(document2, true);
                    LOG.trace(inspector.getClass() + " inspected " + string2 + ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false) + "\r\n" + string4);
                }
                if (!document2.hasChildNodes()) continue;
                if (document == null || !document.hasChildNodes()) {
                    document = document2;
                    continue;
                }
                XmlUtils.combineElements(document.getDocumentElement(), document2.getDocumentElement(), "type", "name");
            }
            if (document == null || !document.hasChildNodes()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No inspectors matched path == " + string2 + ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false));
                }
                return null;
            }
            if (LOG.isDebugEnabled()) {
                object2 = XmlUtils.documentToString(document, true);
                LOG.debug("Inspected " + string2 + ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false) + "\r\n" + (String)object2);
            }
            return XmlUtils.documentToString(document, false);
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected Document parseInspectionResult(String string) throws Exception {
        return XmlUtils.documentFromString(string);
    }
}

