/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesInspectorConfig;
import org.metawidget.inspector.faces.UiFacesAjax;
import org.metawidget.inspector.faces.UiFacesAttribute;
import org.metawidget.inspector.faces.UiFacesAttributes;
import org.metawidget.inspector.faces.UiFacesComponent;
import org.metawidget.inspector.faces.UiFacesConverter;
import org.metawidget.inspector.faces.UiFacesDateTimeConverter;
import org.metawidget.inspector.faces.UiFacesLookup;
import org.metawidget.inspector.faces.UiFacesNumberConverter;
import org.metawidget.inspector.faces.UiFacesSuggest;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.ThreadUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesInspector
extends BaseObjectInspector {
    private static final ThreadLocal<Object> LOCAL_TOINSPECT = ThreadUtils.newThreadLocal();
    private boolean mInjectThis;

    public FacesInspector() {
        this(new FacesInspectorConfig());
    }

    public FacesInspector(FacesInspectorConfig facesInspectorConfig) {
        super(facesInspectorConfig);
        this.mInjectThis = facesInspectorConfig.isInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, String> inspectParent(Object object, Property property) throws Exception {
        try {
            if (this.mInjectThis) {
                LOCAL_TOINSPECT.set(object);
            }
            Map<String, String> map = super.inspectParent(object, property);
            return map;
        }
        finally {
            LOCAL_TOINSPECT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void inspect(Object object, Class<?> clazz, Element element) throws Exception {
        try {
            if (this.mInjectThis) {
                LOCAL_TOINSPECT.set(object);
            }
            super.inspect(object, clazz, element);
        }
        finally {
            if (this.mInjectThis) {
                LOCAL_TOINSPECT.remove();
            }
        }
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        UiFacesAttributes uiFacesAttributes = trait.getAnnotation(UiFacesAttributes.class);
        UiFacesAttribute uiFacesAttribute = trait.getAnnotation(UiFacesAttribute.class);
        if (uiFacesAttributes == null && uiFacesAttribute == null) {
            return null;
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw InspectorException.newException("FacesContext not available to FacesInspector");
        }
        Application application = facesContext.getApplication();
        if (uiFacesAttribute != null) {
            this.putFacesAttribute(facesContext, application, hashMap, uiFacesAttribute);
        }
        if (uiFacesAttributes != null) {
            for (UiFacesAttribute uiFacesAttribute2 : uiFacesAttributes.value()) {
                this.putFacesAttribute(facesContext, application, hashMap, uiFacesAttribute2);
            }
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiFacesDateTimeConverter uiFacesDateTimeConverter;
        UiFacesNumberConverter uiFacesNumberConverter;
        UiFacesConverter uiFacesConverter;
        UiFacesAjax uiFacesAjax;
        UiFacesComponent uiFacesComponent;
        UiFacesSuggest uiFacesSuggest;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        UiFacesLookup uiFacesLookup = property.getAnnotation(UiFacesLookup.class);
        if (uiFacesLookup != null) {
            hashMap.put("faces-lookup", uiFacesLookup.value());
        }
        if ((uiFacesSuggest = property.getAnnotation(UiFacesSuggest.class)) != null) {
            hashMap.put("faces-suggest", uiFacesSuggest.value());
        }
        if ((uiFacesComponent = property.getAnnotation(UiFacesComponent.class)) != null) {
            hashMap.put("faces-component", uiFacesComponent.value());
        }
        if ((uiFacesAjax = property.getAnnotation(UiFacesAjax.class)) != null) {
            hashMap.put("faces-ajax-event", uiFacesAjax.event());
            if (!"".equals(uiFacesAjax.action())) {
                if (!FacesUtils.isExpression(uiFacesAjax.action())) {
                    throw InspectorException.newException("Expression '" + uiFacesAjax.action() + "' is not of the form #{...}");
                }
                hashMap.put("faces-ajax-action", uiFacesAjax.action());
            }
        }
        if ((uiFacesConverter = property.getAnnotation(UiFacesConverter.class)) != null) {
            hashMap.put("faces-converter-id", uiFacesConverter.value());
        }
        if ((uiFacesNumberConverter = property.getAnnotation(UiFacesNumberConverter.class)) != null) {
            if (!"".equals(uiFacesNumberConverter.currencyCode())) {
                hashMap.put("currency-code", uiFacesNumberConverter.currencyCode());
            }
            if (!"".equals(uiFacesNumberConverter.currencySymbol())) {
                hashMap.put("currency-symbol", uiFacesNumberConverter.currencySymbol());
            }
            if (uiFacesNumberConverter.groupingUsed()) {
                hashMap.put("number-uses-grouping-separators", "true");
            }
            if (uiFacesNumberConverter.minIntegerDigits() != -1) {
                hashMap.put("minimum-integer-digits", String.valueOf(uiFacesNumberConverter.minIntegerDigits()));
            }
            if (uiFacesNumberConverter.maxIntegerDigits() != -1) {
                hashMap.put("maximum-integer-digits", String.valueOf(uiFacesNumberConverter.maxIntegerDigits()));
            }
            if (uiFacesNumberConverter.minFractionDigits() != -1) {
                hashMap.put("minimum-fractional-digits", String.valueOf(uiFacesNumberConverter.minFractionDigits()));
            }
            if (uiFacesNumberConverter.maxFractionDigits() != -1) {
                hashMap.put("maximum-fractional-digits", String.valueOf(uiFacesNumberConverter.maxFractionDigits()));
            }
            if (!"".equals(uiFacesNumberConverter.locale())) {
                hashMap.put("locale", uiFacesNumberConverter.locale());
            }
            if (!"".equals(uiFacesNumberConverter.pattern())) {
                hashMap.put("number-pattern", uiFacesNumberConverter.pattern());
            }
            if (!"".equals(uiFacesNumberConverter.type())) {
                hashMap.put("number-type", uiFacesNumberConverter.type());
            }
        }
        if ((uiFacesDateTimeConverter = property.getAnnotation(UiFacesDateTimeConverter.class)) != null) {
            if (!"".equals(uiFacesDateTimeConverter.dateStyle())) {
                hashMap.put("date-style", uiFacesDateTimeConverter.dateStyle());
            }
            if (!"".equals(uiFacesDateTimeConverter.locale())) {
                hashMap.put("locale", uiFacesDateTimeConverter.locale());
            }
            if (!"".equals(uiFacesDateTimeConverter.pattern())) {
                hashMap.put("datetime-pattern", uiFacesDateTimeConverter.pattern());
            }
            if (!"".equals(uiFacesDateTimeConverter.timeStyle())) {
                hashMap.put("time-style", uiFacesDateTimeConverter.timeStyle());
            }
            if (!"".equals(uiFacesDateTimeConverter.timeZone())) {
                hashMap.put("time-zone", uiFacesDateTimeConverter.timeZone());
            }
            if (!"".equals(uiFacesDateTimeConverter.type())) {
                hashMap.put("datetime-type", uiFacesDateTimeConverter.type());
            }
        }
        return hashMap;
    }

    protected void putFacesAttribute(FacesContext facesContext, Application application, Map<String, String> map, UiFacesAttribute uiFacesAttribute) {
        Object object;
        String string = uiFacesAttribute.expression();
        if (!FacesUtils.isExpression(string)) {
            throw InspectorException.newException("Expression '" + string + "' is not of the form #{...}");
        }
        if (this.mInjectThis) {
            facesContext.getExternalContext().getRequestMap().put("this", LOCAL_TOINSPECT.get());
        }
        if ((object = application.createValueBinding(string).getValue(facesContext)) == null) {
            return;
        }
        map.put(uiFacesAttribute.name(), StringUtils.quietValueOf(object));
    }
}

