/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.Pair;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseObjectInspector
implements Inspector {
    private final PropertyStyle mPropertyStyle;
    private final ActionStyle mActionStyle;
    protected final LogUtils.Log mLog = LogUtils.getLog(this.getClass());

    protected BaseObjectInspector() {
        this(new BaseObjectInspectorConfig());
    }

    protected BaseObjectInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        this.mPropertyStyle = baseObjectInspectorConfig.getPropertyStyle();
        this.mActionStyle = baseObjectInspectorConfig.getActionStyle();
    }

    @Override
    public String inspect(Object object, String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Object object2;
            Pair<Object, Class<?>> pair;
            Object object3 = null;
            String string2 = null;
            Map<String, String> map = null;
            if (stringArray != null && stringArray.length > 0) {
                pair = this.traverse(object, string, true, stringArray);
                if (pair == null) {
                    return null;
                }
                string2 = stringArray[stringArray.length - 1];
                object2 = pair.getLeft();
                clazz2 = object2.getClass();
                Property property = this.mPropertyStyle.getProperties(clazz2).get(string2);
                if (property == null) {
                    return null;
                }
                clazz = property.getType();
                if (property.isReadable()) {
                    map = this.inspectParent(object2, property);
                    object3 = property.read(object2);
                }
            } else {
                pair = this.traverse(object, string, false, new String[0]);
                if (pair == null) {
                    return null;
                }
                object3 = pair.getLeft();
                clazz = pair.getRight();
            }
            pair = XmlUtils.newDocumentBuilder().newDocument();
            object2 = pair.createElementNS("http://metawidget.org/inspection-result", "entity");
            if (object3 == null || clazz.isPrimitive()) {
                XmlUtils.setMapAsAttributes((Element)object2, this.inspectEntity(clazz, clazz));
                if (stringArray == null || stringArray.length == 0) {
                    this.inspect(object3, clazz, (Element)object2);
                }
            } else {
                clazz2 = object3.getClass();
                XmlUtils.setMapAsAttributes((Element)object2, this.inspectEntity(clazz, clazz2));
                this.inspect(object3, clazz2, (Element)object2);
            }
            XmlUtils.setMapAsAttributes((Element)object2, map);
            if (this.isInspectionEmpty((Element)object2)) {
                return null;
            }
            clazz2 = pair.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            clazz2.setAttribute("version", "1.0");
            pair.appendChild((Node)((Object)clazz2));
            clazz2.appendChild((Node)object2);
            if (string2 != null) {
                object2.setAttribute("name", string2);
            }
            object2.setAttribute("type", clazz.getName());
            return XmlUtils.documentToString((Document)((Object)pair), false);
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected Map<String, String> inspectParent(Object object, Property property) throws Exception {
        Map<String, String> map = this.inspectTrait(property);
        Map<String, String> map2 = this.inspectProperty(property);
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        map.putAll(map2);
        return map;
    }

    protected void inspect(Object object, Class<?> clazz, Element element) throws Exception {
        Object object2;
        Map<String, String> map;
        Map<String, String> map2;
        Document document = element.getOwnerDocument();
        for (Property trait : this.getProperties(clazz).values()) {
            map2 = this.inspectTrait(trait);
            map = this.inspectProperty(trait);
            object2 = this.inspectPropertyAsEntity(trait, object);
            if (!(map2 != null && !map2.isEmpty() || map != null && !map.isEmpty() || object2 != null && !object2.isEmpty())) continue;
            Element element2 = document.createElementNS("http://metawidget.org/inspection-result", "property");
            element2.setAttribute("name", trait.getName());
            XmlUtils.setMapAsAttributes(element2, map2);
            XmlUtils.setMapAsAttributes(element2, map);
            XmlUtils.setMapAsAttributes(element2, (Map<String, String>)object2);
            element.appendChild(element2);
        }
        for (Action action : this.getActions(clazz).values()) {
            map2 = this.inspectTrait(action);
            map = this.inspectAction(action);
            if (!(map2 != null && !map2.isEmpty() || map != null && !map.isEmpty())) continue;
            object2 = document.createElementNS("http://metawidget.org/inspection-result", "action");
            object2.setAttribute("name", action.getName());
            XmlUtils.setMapAsAttributes((Element)object2, map2);
            XmlUtils.setMapAsAttributes((Element)object2, map);
            element.appendChild((Node)object2);
        }
    }

    protected Map<String, String> inspectEntity(Class<?> clazz, Class<?> clazz2) throws Exception {
        return null;
    }

    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        return null;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        return null;
    }

    protected Map<String, String> inspectAction(Action action) throws Exception {
        return null;
    }

    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return false;
    }

    protected final Map<String, Property> getProperties(Class<?> clazz) {
        if (this.mPropertyStyle == null) {
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        return this.mPropertyStyle.getProperties(clazz);
    }

    protected final Map<String, Action> getActions(Class<?> clazz) {
        if (this.mActionStyle == null) {
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        return this.mActionStyle.getActions(clazz);
    }

    private Map<String, String> inspectPropertyAsEntity(Property property, Object object) throws Exception {
        if (!this.shouldInspectPropertyAsEntity(property)) {
            return null;
        }
        Class<?> clazz = property.getType();
        if (property.isReadable() && !Modifier.isFinal(clazz.getModifiers())) {
            Object object2 = null;
            try {
                object2 = property.read(object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object2 != null) {
                clazz = object2.getClass();
            }
        }
        return this.inspectEntity(property.getType(), clazz);
    }

    private boolean isInspectionEmpty(Element element) {
        if (element.hasAttributes()) {
            return false;
        }
        return !element.hasChildNodes();
    }

    private Pair<Object, Class<?>> traverse(Object object, String string, boolean bl, String[] stringArray) {
        if (object == null) {
            if (bl) {
                return null;
            }
            Class<?> clazz = ClassUtils.niceForName(string);
            if (clazz == null) {
                return null;
            }
            return new Pair(null, clazz);
        }
        Class<?> clazz = ClassUtils.niceForName(string, object.getClass().getClassLoader());
        if (clazz == null || !clazz.isAssignableFrom(object.getClass())) {
            return null;
        }
        Object object2 = object;
        if (stringArray != null && stringArray.length > 0) {
            HashSet hashSet = CollectionUtils.newHashSet();
            hashSet.add(object2);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                Property property = this.mPropertyStyle.getProperties(object2.getClass()).get(string2);
                if (property == null || !property.isReadable()) {
                    return null;
                }
                Object object3 = object2;
                if (!hashSet.add(object2 = property.read(object2))) {
                    this.mLog.trace(new StringBuffer().append(ClassUtils.getSimpleName(this.getClass())).append(" prevented infinite recursion on ").append(string).append(ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).append(". Consider annotating ").append(string2).append(" as @UiHidden").toString());
                    return null;
                }
                if (bl && i >= n - 1) {
                    return new Pair(object3, clazz);
                }
                if (object2 == null) {
                    return null;
                }
                clazz = property.getType();
            }
        }
        return new Pair(object2, clazz);
    }
}

