/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import org.metawidget.inspector.impl.actionstyle.ActionStyle;
import org.metawidget.inspector.impl.actionstyle.metawidget.MetawidgetActionStyle;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.util.simple.ObjectUtils;

public class BaseObjectInspectorConfig {
    private static PropertyStyle DEFAULT_PROPERTY_STYLE;
    private static ActionStyle DEFAULT_ACTION_STYLE;
    protected PropertyStyle mPropertyStyle;
    protected boolean mNullPropertyStyle;
    protected ActionStyle mActionStyle;
    protected boolean mNullActionStyle;

    public BaseObjectInspectorConfig setPropertyStyle(PropertyStyle propertyStyle) {
        this.mPropertyStyle = propertyStyle;
        if (propertyStyle == null) {
            this.mNullPropertyStyle = true;
        }
        return this;
    }

    public BaseObjectInspectorConfig setActionStyle(ActionStyle actionStyle) {
        this.mActionStyle = actionStyle;
        if (actionStyle == null) {
            this.mNullActionStyle = true;
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mPropertyStyle, ((BaseObjectInspectorConfig)object).mPropertyStyle)) {
            return false;
        }
        if (this.mNullPropertyStyle != ((BaseObjectInspectorConfig)object).mNullPropertyStyle) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mActionStyle, ((BaseObjectInspectorConfig)object).mActionStyle)) {
            return false;
        }
        return this.mNullActionStyle == ((BaseObjectInspectorConfig)object).mNullActionStyle;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mPropertyStyle);
        n = 31 * n + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullPropertyStyle));
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mActionStyle);
        n = 31 * n + ObjectUtils.nullSafeHashCode(new Boolean(this.mNullActionStyle));
        return n;
    }

    protected PropertyStyle getPropertyStyle() {
        if (this.mPropertyStyle == null && !this.mNullPropertyStyle) {
            if (DEFAULT_PROPERTY_STYLE == null) {
                DEFAULT_PROPERTY_STYLE = new JavaBeanPropertyStyle();
            }
            return DEFAULT_PROPERTY_STYLE;
        }
        return this.mPropertyStyle;
    }

    protected ActionStyle getActionStyle() {
        if (this.mActionStyle == null && !this.mNullActionStyle) {
            if (DEFAULT_ACTION_STYLE == null) {
                try {
                    DEFAULT_ACTION_STYLE = new MetawidgetActionStyle();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return DEFAULT_ACTION_STYLE;
        }
        return this.mActionStyle;
    }
}

