/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import org.metawidget.config.NeedsResourceResolver;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.simple.ObjectUtils;

public class BaseXmlInspectorConfig
implements NeedsResourceResolver {
    private String mDefaultFile;
    private ResourceResolver mResourceResolver;
    private InputStream[] mInputStreams;
    private PropertyStyle mRestrictAgainstObject;

    public InputStream[] getInputStreams() {
        if (this.mInputStreams == null && this.mDefaultFile != null) {
            if (this.mResourceResolver != null) {
                return new InputStream[]{this.mResourceResolver.openResource(this.mDefaultFile)};
            }
            try {
                return new InputStream[]{ClassUtils.openResource(this.mDefaultFile)};
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }
        return this.mInputStreams;
    }

    public BaseXmlInspectorConfig setInputStreams(InputStream[] inputStreamArray) {
        this.mInputStreams = inputStreamArray;
        return this;
    }

    public BaseXmlInspectorConfig setInputStream(InputStream inputStream) {
        this.mDefaultFile = null;
        this.mInputStreams = new InputStream[]{inputStream};
        return this;
    }

    public ResourceResolver getResourceResolver() {
        if (this.mResourceResolver == null) {
            return new ResourceResolver(){

                public InputStream openResource(String string) {
                    try {
                        return ClassUtils.openResource(string);
                    }
                    catch (Exception exception) {
                        throw InspectorException.newException(exception);
                    }
                }
            };
        }
        return this.mResourceResolver;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
    }

    public PropertyStyle getRestrictAgainstObject() {
        return this.mRestrictAgainstObject;
    }

    public BaseXmlInspectorConfig setRestrictAgainstObject(PropertyStyle propertyStyle) {
        this.mRestrictAgainstObject = propertyStyle;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mDefaultFile, ((BaseXmlInspectorConfig)object).mDefaultFile)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mResourceResolver, ((BaseXmlInspectorConfig)object).mResourceResolver)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mInputStreams, ((BaseXmlInspectorConfig)object).mInputStreams)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mRestrictAgainstObject, ((BaseXmlInspectorConfig)object).mRestrictAgainstObject);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mDefaultFile);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mResourceResolver);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mInputStreams);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mRestrictAgainstObject);
        return n;
    }

    protected void setDefaultFile(String string) {
        this.mDefaultFile = string;
    }
}

