/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.actionstyle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.impl.actionstyle.Action;
import org.metawidget.inspector.impl.actionstyle.BaseAction;
import org.metawidget.inspector.impl.actionstyle.BaseActionStyle;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodActionStyle
extends BaseActionStyle {
    @Override
    protected Map<String, Action> inspectActions(Class<?> clazz) {
        TreeMap<String, Action> treeMap = CollectionUtils.newTreeMap();
        for (Method method : clazz.getMethods()) {
            if (!this.matchAction(method) || this.isExcluded(method)) continue;
            String string = method.getName();
            treeMap.put(string, new MethodAction(string, method));
        }
        return treeMap;
    }

    protected boolean isExcluded(Method method) {
        return false;
    }

    protected abstract boolean matchAction(Method var1);

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodAction
    extends BaseAction {
        private Method mMethod;

        public MethodAction(String string, Method method) {
            super(string);
            this.mMethod = method;
            if (this.mMethod == null) {
                throw new NullPointerException("method");
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.mMethod.getAnnotation(clazz);
        }
    }
}

