/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePropertyStyle
implements PropertyStyle {
    private final Map<Class<?>, Map<String, Property>> mPropertiesCache = CollectionUtils.newHashMap();
    private Pattern mExcludeBaseType;
    static /* synthetic */ Class class$java$lang$Object;

    protected BasePropertyStyle(BasePropertyStyleConfig basePropertyStyleConfig) {
        this.mExcludeBaseType = basePropertyStyleConfig.getExcludeBaseType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Property> getProperties(Class<?> clazz) {
        Map<Class<?>, Map<String, Property>> map = this.mPropertiesCache;
        synchronized (map) {
            Map<String, Property> map2 = this.getCachedProperties(clazz);
            if (map2 == null) {
                if (!this.isProxy(clazz)) {
                    map2 = this.inspectProperties(clazz);
                } else {
                    Class<?> clazz2 = clazz.getSuperclass();
                    if (!clazz2.equals(class$java$lang$Object == null ? (class$java$lang$Object = BasePropertyStyle.class$("java.lang.Object")) : class$java$lang$Object)) {
                        map2 = this.getCachedProperties(clazz2);
                        if (map2 == null) {
                            map2 = this.inspectProperties(clazz2);
                            this.cacheProperties(clazz2, map2);
                        }
                    } else {
                        map2 = this.inspectProperties(clazz.getInterfaces());
                    }
                }
                this.cacheProperties(clazz, map2);
            }
            return map2;
        }
    }

    protected boolean isExcluded(Class<?> clazz, String string, Class<?> clazz2) {
        if (this.isExcludedBaseType(clazz)) {
            return true;
        }
        if (this.isExcludedReturnType(clazz2)) {
            return true;
        }
        return this.isExcludedName(string);
    }

    protected boolean isExcludedBaseType(Class<?> clazz) {
        String string = clazz.getName();
        return this.mExcludeBaseType != null && this.mExcludeBaseType.matcher(string).matches();
    }

    protected boolean isExcludedName(String string) {
        return false;
    }

    protected boolean isExcludedReturnType(Class<?> clazz) {
        return false;
    }

    protected boolean isProxy(Class<?> clazz) {
        String string = clazz.getName();
        if (string.indexOf("_$$_javassist_") != -1) {
            return true;
        }
        return string.indexOf("ByCGLIB$$") != -1;
    }

    protected Map<String, Property> inspectProperties(Class<?>[] classArray) {
        TreeMap<String, Property> treeMap = CollectionUtils.newTreeMap();
        for (Class<?> clazz : classArray) {
            Map<String, Property> map = this.getCachedProperties(clazz);
            if (map == null) {
                map = this.inspectProperties(clazz);
                this.cacheProperties(clazz, map);
            }
            treeMap.putAll(map);
        }
        return treeMap;
    }

    protected abstract Map<String, Property> inspectProperties(Class<?> var1);

    protected Map<String, Property> getCachedProperties(Class<?> clazz) {
        return this.mPropertiesCache.get(clazz);
    }

    protected void cacheProperties(Class<?> clazz, Map<String, Property> map) {
        this.mPropertiesCache.put(clazz, Collections.unmodifiableMap(map));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

