/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javabean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanPropertyStyle
extends BasePropertyStyle {
    public JavaBeanPropertyStyle() {
        this(new BasePropertyStyleConfig());
    }

    public JavaBeanPropertyStyle(BasePropertyStyleConfig basePropertyStyleConfig) {
        super(basePropertyStyleConfig);
    }

    @Override
    protected Map<String, Property> inspectProperties(Class<?> clazz) {
        TreeMap<String, Property> treeMap = CollectionUtils.newTreeMap();
        this.lookupFields(treeMap, clazz);
        this.lookupGetters(treeMap, clazz);
        this.lookupSetters(treeMap, clazz);
        return treeMap;
    }

    protected void lookupFields(Map<String, Property> map, Class<?> clazz) {
        for (Field field : clazz.getFields()) {
            int n = field.getModifiers();
            if (Modifier.isStatic(n)) continue;
            String string = field.getName();
            Class<?> clazz2 = field.getType();
            if (this.isExcluded(field.getDeclaringClass(), string, clazz2)) continue;
            map.put(string, new FieldProperty(string, field));
        }
    }

    protected void lookupGetters(Map<String, Property> map, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            JavaBeanProperty javaBeanProperty;
            String string;
            Class<?> clazz2;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 0 || Void.TYPE.equals(clazz2 = method.getReturnType()) || (string = this.isGetter(method)) == null || this.isExcluded(method.getDeclaringClass(), string, clazz2)) continue;
            Property property = map.get(string);
            if (property instanceof FieldProperty) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(((FieldProperty)property).getField()).append("' has both a public member variable and a public getter method. Should be one or the other").toString());
            }
            if (property instanceof JavaBeanProperty && clazz2.isAssignableFrom((javaBeanProperty = (JavaBeanProperty)property).getType())) continue;
            map.put(string, new JavaBeanProperty(string, clazz2, method, null));
        }
    }

    protected String isGetter(Method method) {
        String string;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring("get".length());
        } else if (string2.startsWith("is")) {
            string = string2.substring("is".length());
        } else {
            return null;
        }
        if (!StringUtils.isFirstLetterUppercase(string)) {
            return null;
        }
        return StringUtils.lowercaseFirstLetter(string);
    }

    protected void lookupSetters(Map<String, Property> map, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) continue;
            Class<?> clazz2 = classArray[0];
            String string = this.isSetter(method);
            if (string == null || this.isExcluded(method.getDeclaringClass(), string, clazz2)) continue;
            Property property = map.get(string);
            if (property instanceof FieldProperty) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(((FieldProperty)property).getField()).append("' has both a public member variable and a public setter method. Should be one or the other").toString());
            }
            if (property instanceof JavaBeanProperty) {
                JavaBeanProperty javaBeanProperty = (JavaBeanProperty)property;
                map.put(string, new JavaBeanProperty(string, javaBeanProperty.getType(), javaBeanProperty.getReadMethod(), method));
                continue;
            }
            map.put(string, new JavaBeanProperty(string, clazz2, null, method));
        }
    }

    protected String isSetter(Method method) {
        String string = method.getName();
        if (!string.startsWith("set")) {
            return null;
        }
        String string2 = string.substring("set".length());
        if (!StringUtils.isFirstLetterUppercase(string2)) {
            return null;
        }
        return StringUtils.lowercaseFirstLetter(string2);
    }

    @Override
    protected boolean isExcludedName(String string) {
        if ("propertyChangeListeners".equals(string)) {
            return true;
        }
        if ("vetoableChangeListeners".equals(string)) {
            return true;
        }
        return super.isExcludedName(string);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JavaBeanProperty
    extends BaseProperty {
        private Method mReadMethod;
        private Method mWriteMethod;

        public JavaBeanProperty(String string, Class<?> clazz, Method method, Method method2) {
            super(string, clazz);
            this.mReadMethod = method;
            this.mWriteMethod = method2;
            if (this.mReadMethod == null && this.mWriteMethod == null) {
                throw InspectorException.newException(new StringBuffer().append("JavaBeanProperty '").append(string).append("' has no getter and no setter").toString());
            }
        }

        @Override
        public boolean isReadable() {
            return this.mReadMethod != null;
        }

        @Override
        public Object read(Object object) {
            try {
                return this.mReadMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mWriteMethod != null;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            T t;
            if (this.mReadMethod != null && (t = this.mReadMethod.getAnnotation(clazz)) != null) {
                return t;
            }
            if (this.mWriteMethod != null) {
                t = this.mWriteMethod.getAnnotation(clazz);
                if (t != null) {
                    return t;
                }
                return null;
            }
            return null;
        }

        @Override
        public Type getGenericType() {
            if (this.mReadMethod != null) {
                return this.mReadMethod.getGenericReturnType();
            }
            return this.mWriteMethod.getGenericParameterTypes()[0];
        }

        public Method getReadMethod() {
            return this.mReadMethod;
        }

        public Method getWriteMethod() {
            return this.mWriteMethod;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldProperty
    extends BaseProperty {
        private Field mField;

        public FieldProperty(String string, Field field) {
            super(string, field.getType());
            this.mField = field;
            if (this.mField == null) {
                throw new NullPointerException("field");
            }
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public Object read(Object object) {
            try {
                return this.mField.get(object);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.mField.getAnnotation(clazz);
        }

        @Override
        public Type getGenericType() {
            return this.mField.getGenericType();
        }

        public Field getField() {
            return this.mField;
        }
    }
}

