/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.java5;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java5Inspector
extends BaseObjectInspector {
    public Java5Inspector() {
        this(new BaseObjectInspectorConfig());
    }

    public Java5Inspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return true;
    }

    @Override
    protected Map<String, String> inspectEntity(Class<?> clazz, Class<?> clazz2) throws Exception {
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (Enum.class.isAssignableFrom(clazz2)) {
            Method method = clazz2.getMethod("values", new Class[0]);
            Enum[] enumArray = (Enum[])method.invoke(clazz2, new Object[0]);
            ArrayList arrayList = CollectionUtils.newArrayList();
            ArrayList arrayList2 = CollectionUtils.newArrayList();
            for (Enum enum_ : enumArray) {
                arrayList.add(enum_.name());
                arrayList2.add(enum_.toString());
            }
            hashMap.put("lookup", CollectionUtils.toString(arrayList));
            hashMap.put("lookup-labels", CollectionUtils.toString(arrayList2));
            if (clazz2.isEnum()) {
                hashMap.put("type", clazz2.getName());
            } else {
                hashMap.put("type", clazz2.getSuperclass().getName());
            }
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        Type type = property.getGenericType();
        if (type instanceof ParameterizedType) {
            Type[] typeArray = null;
            try {
                typeArray = ((ParameterizedType)type).getActualTypeArguments();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (typeArray != null && typeArray.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Type type2 : typeArray) {
                    if (type2 == null) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(StringUtils.SEPARATOR_COMMA);
                    }
                    if (type2 instanceof Class) {
                        stringBuilder.append(((Class)type2).getName());
                        continue;
                    }
                    stringBuilder.append(type2.toString());
                }
                hashMap.put("parameterized-type", stringBuilder.toString());
            }
        }
        return hashMap;
    }
}

