/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.xml;

import java.util.Map;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.xml.XmlInspectorConfig;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlInspector
extends BaseXmlInspector {
    public XmlInspector(XmlInspectorConfig xmlInspectorConfig) {
        super(xmlInspectorConfig);
    }

    @Override
    protected String getExtendsAttribute() {
        return "extends";
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        if ("property".equals(element.getNodeName())) {
            Map<String, String> map = XmlUtils.getAttributesAsMap(element);
            if (map.containsKey("readonly")) {
                throw InspectorException.newException("Attribute named 'readonly' should be 'read-only'");
            }
            if (map.containsKey("dontexpand")) {
                throw InspectorException.newException("Attribute named 'dontexpand' should be 'dont-expand'");
            }
            return map;
        }
        return null;
    }

    @Override
    protected Map<String, String> inspectAction(Element element) {
        if ("action".equals(element.getNodeName())) {
            return XmlUtils.getAttributesAsMap(element);
        }
        return null;
    }
}

