/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecorator;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.layout.decorator.NestedSectionLayoutDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlatSectionLayoutDecorator<W, C extends W, M extends C>
extends LayoutDecorator<W, C, M> {
    protected FlatSectionLayoutDecorator(LayoutDecoratorConfig<W, C, M> layoutDecoratorConfig) {
        super(layoutDecoratorConfig);
    }

    @Override
    public void startContainerLayout(C c, M m) {
        super.startContainerLayout(c, m);
        State state = this.getState(c, m);
        state.currentSections = null;
    }

    @Override
    public void layoutWidget(W w, String string, Map<String, String> map, C c, M m) {
        State state = this.getState(c, m);
        if (this.getDelegate() instanceof NestedSectionLayoutDecorator) {
            String string2 = this.stripSection(map);
            if (string2 == null || state.currentSections != null && string2.equals(state.currentSections[0])) {
                super.layoutWidget(w, string, map, c, m);
                return;
            }
            if (state.currentSections != null && !string2.equals(state.currentSections[0])) {
                super.endContainerLayout(c, m);
            }
            if (this.isEmptyStub(w)) {
                return;
            }
            state.currentSections = new String[]{string2};
            if (!"".equals(string2)) {
                this.addSectionWidget(string2, 0, c, m);
            }
        } else {
            String[] stringArray = this.getSections(map);
            if (stringArray.length == 0 || stringArray.equals(state.currentSections)) {
                super.layoutWidget(w, string, map, c, m);
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if ("".equals(string3) || state.currentSections != null && i < state.currentSections.length && string3.equals(state.currentSections[i]) || this.isEmptyStub(w)) continue;
                this.addSectionWidget(string3, i, c, m);
            }
            state.currentSections = stringArray;
        }
        super.layoutWidget(w, string, map, c, m);
    }

    protected abstract String stripSection(Map<String, String> var1);

    protected abstract String[] getSections(Map<String, String> var1);

    protected abstract State getState(C var1, M var2);

    protected abstract boolean isEmptyStub(W var1);

    protected abstract void addSectionWidget(String var1, int var2, C var3, M var4);

    public static class State {
        public String[] currentSections;
    }
}

