/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.pipeline.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasePipeline<W, C extends W, E, M extends C> {
    private static final int DEFAULT_MAXIMUM_INSPECTION_DEPTH = 10;
    private boolean mReadOnly;
    private int mMaximumInspectionDepth = 10;
    private Inspector mInspector;
    private List<InspectionResultProcessor<E, M>> mInspectionResultProcessors;
    private WidgetBuilder<W, M> mWidgetBuilder;
    private List<WidgetProcessor<W, M>> mWidgetProcessors;
    private Layout<W, C, M> mLayout;

    public void setReadOnly(boolean bl) {
        this.mReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    public int getMaximumInspectionDepth() {
        return this.mMaximumInspectionDepth;
    }

    public void setMaximumInspectionDepth(int n) {
        this.mMaximumInspectionDepth = n;
    }

    public void setInspector(Inspector inspector) {
        this.mInspector = inspector;
    }

    public Inspector getInspector() {
        return this.mInspector;
    }

    public List<InspectionResultProcessor<E, M>> getInspectionResultProcessors() {
        return this.mInspectionResultProcessors;
    }

    public void setInspectionResultProcessors(List<InspectionResultProcessor<E, M>> list) {
        this.mInspectionResultProcessors = list;
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<E, M> inspectionResultProcessor) {
        if (this.mInspectionResultProcessors == null) {
            this.mInspectionResultProcessors = new ArrayList<InspectionResultProcessor<E, M>>();
        }
        this.mInspectionResultProcessors.add(inspectionResultProcessor);
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<E, M> inspectionResultProcessor) {
        if (this.mInspectionResultProcessors == null) {
            return;
        }
        this.mInspectionResultProcessors.remove(inspectionResultProcessor);
    }

    public void setWidgetBuilder(WidgetBuilder<W, M> widgetBuilder) {
        this.mWidgetBuilder = widgetBuilder;
    }

    public WidgetBuilder<W, M> getWidgetBuilder() {
        return this.mWidgetBuilder;
    }

    public List<WidgetProcessor<W, M>> getWidgetProcessors() {
        return this.mWidgetProcessors;
    }

    public void setWidgetProcessors(List<WidgetProcessor<W, M>> list) {
        this.mWidgetProcessors = list;
    }

    public void addWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        if (this.mWidgetProcessors == null) {
            this.mWidgetProcessors = new ArrayList<WidgetProcessor<W, M>>();
        }
        this.mWidgetProcessors.add(widgetProcessor);
    }

    public void removeWidgetProcessor(WidgetProcessor<W, M> widgetProcessor) {
        if (this.mWidgetProcessors == null) {
            return;
        }
        this.mWidgetProcessors.remove(widgetProcessor);
    }

    public Layout<W, C, M> getLayout() {
        return this.mLayout;
    }

    public void setLayout(Layout<W, C, M> layout) {
        this.mLayout = layout;
    }

    public E inspect(Object object, String string, String[] stringArray) {
        if (this.mInspector == null) {
            throw new NullPointerException("No inspector configured");
        }
        String string2 = this.mInspector.inspect(object, string, stringArray);
        if (string2 == null) {
            return null;
        }
        E e = this.getDocumentElement(string2);
        return this.processInspectionResult(e);
    }

    public void buildWidgets(E e) throws Exception {
        this.startBuild();
        if (e != null) {
            String string;
            W w;
            E e2 = this.getChildAt(e, 0);
            Map<String, String> map = this.getAttributesAsMap(e2);
            if (this.isReadOnly()) {
                map.put("read-only", "true");
            }
            if ((w = this.buildWidget(string = this.getElementName(e2), map)) == null) {
                this.buildCompoundWidget(e2);
            } else if ((w = this.processWidget(w, string, map)) != null) {
                this.layoutWidget(w, string, map);
            }
        }
        this.endBuild();
    }

    public void initNestedPipeline(BasePipeline<W, C, E, M> basePipeline, Map<String, String> map) {
        basePipeline.setReadOnly(this.isReadOnly() || "true".equals(map.get("read-only")));
        basePipeline.setMaximumInspectionDepth(this.getMaximumInspectionDepth() - 1);
        basePipeline.setInspector(this.getInspector());
        basePipeline.setWidgetBuilder(this.getWidgetBuilder());
        basePipeline.setWidgetProcessors(this.getWidgetProcessors());
        basePipeline.setLayout(this.getLayout());
    }

    protected void buildCompoundWidget(E e) throws Exception {
        int n = this.getChildCount(e);
        for (int i = 0; i < n; ++i) {
            Map<String, String> map;
            String string;
            Object object;
            E e2 = this.getChildAt(e, i);
            if (e2 == null) continue;
            Map<String, String> map2 = this.getAttributesAsMap(e2);
            String string2 = map2.get("name");
            if (string2 == null || "".equals(string2)) {
                throw new Exception(new StringBuffer().append("Child element #").append(i).append(" of '").append(map2.get("type")).append("' has no @").append("name").toString());
            }
            boolean bl = false;
            if (!"true".equals(map2.get("read-only")) && this.isReadOnly()) {
                map2.put("read-only", "true");
                bl = true;
            }
            if ((object = this.buildWidget(string = this.getElementName(e2), map2)) == null) {
                if (this.mMaximumInspectionDepth <= 0) continue;
                if (bl) {
                    map2.remove("read-only");
                }
                object = this.buildNestedMetawidget(map2);
            }
            if ((map = this.getAdditionalAttributes(object)) != null) {
                map2.putAll(map);
            }
            if ((object = this.processWidget(object, string, map2)) == null) continue;
            this.layoutWidget(object, string, map2);
        }
    }

    protected abstract E getDocumentElement(String var1);

    protected abstract int getChildCount(E var1);

    protected abstract E getChildAt(E var1, int var2);

    protected abstract String getElementName(E var1);

    protected abstract Map<String, String> getAttributesAsMap(E var1);

    protected void startBuild() {
        M m = this.getPipelineOwner();
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onStartBuild(m);
            }
        }
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.onStartBuild(m);
            advancedLayout.startContainerLayout(m, m);
        }
    }

    protected E processInspectionResult(E e) {
        E e2 = e;
        if (this.mInspectionResultProcessors != null) {
            M m = this.getPipelineOwner();
            for (InspectionResultProcessor<E, M> inspectionResultProcessor : this.mInspectionResultProcessors) {
                e2 = inspectionResultProcessor.processInspectionResult(e2, m);
                if (e2 != null) continue;
                return null;
            }
        }
        return e2;
    }

    protected abstract Map<String, String> getAdditionalAttributes(W var1);

    protected W buildWidget(String string, Map<String, String> map) {
        return this.mWidgetBuilder.buildWidget(string, map, this.getPipelineOwner());
    }

    protected W processWidget(W w, String string, Map<String, String> map) {
        W w2 = w;
        if (this.mWidgetProcessors != null) {
            M m = this.getPipelineOwner();
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                w2 = widgetProcessor.processWidget(w2, string, map, m);
                if (w2 != null) continue;
                return null;
            }
        }
        return w2;
    }

    protected abstract M buildNestedMetawidget(Map<String, String> var1) throws Exception;

    protected abstract M getPipelineOwner();

    protected void layoutWidget(W w, String string, Map<String, String> map) {
        M m = this.getPipelineOwner();
        this.mLayout.layoutWidget(w, string, map, m, m);
    }

    protected void endBuild() {
        M m = this.getPipelineOwner();
        if (this.mWidgetProcessors != null) {
            for (WidgetProcessor<W, M> widgetProcessor : this.mWidgetProcessors) {
                if (!(widgetProcessor instanceof AdvancedWidgetProcessor)) continue;
                ((AdvancedWidgetProcessor)widgetProcessor).onEndBuild(m);
            }
        }
        if (this.mLayout instanceof AdvancedLayout) {
            AdvancedLayout advancedLayout = (AdvancedLayout)this.mLayout;
            advancedLayout.endContainerLayout(m, m);
            advancedLayout.onEndBuild(m);
        }
    }
}

