/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.layout;

import java.awt.Color;
import java.awt.Font;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class GridBagLayoutConfig {
    private int mNumberOfColumns = 1;
    private int mLabelAlignment = 2;
    private Color mLabelForeground;
    private Font mLabelFont;
    private String mLabelSuffix = ":";
    private int mRequiredAlignment = 0;
    private String mRequiredText = "*";

    public int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    public GridBagLayoutConfig setNumberOfColumns(int n) {
        if (n < 1) {
            throw LayoutException.newException("numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = n;
        return this;
    }

    public int getLabelAlignment() {
        return this.mLabelAlignment;
    }

    public GridBagLayoutConfig setLabelAlignment(int n) {
        this.mLabelAlignment = n;
        return this;
    }

    public Color getLabelForeground() {
        return this.mLabelForeground;
    }

    public GridBagLayoutConfig setLabelForeground(Color color) {
        this.mLabelForeground = color;
        return this;
    }

    public Font getLabelFont() {
        return this.mLabelFont;
    }

    public GridBagLayoutConfig setLabelFont(Font font) {
        this.mLabelFont = font;
        return this;
    }

    public String getLabelSuffix() {
        return this.mLabelSuffix;
    }

    public GridBagLayoutConfig setLabelSuffix(String string) {
        this.mLabelSuffix = string;
        return this;
    }

    public int getRequiredAlignment() {
        return this.mRequiredAlignment;
    }

    public GridBagLayoutConfig setRequiredAlignment(int n) {
        this.mRequiredAlignment = n;
        return this;
    }

    public String getRequiredText() {
        return this.mRequiredText;
    }

    public GridBagLayoutConfig setRequiredText(String string) {
        this.mRequiredText = string;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.mNumberOfColumns != ((GridBagLayoutConfig)object).mNumberOfColumns) {
            return false;
        }
        if (this.mLabelAlignment != ((GridBagLayoutConfig)object).mLabelAlignment) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelFont, ((GridBagLayoutConfig)object).mLabelFont)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelForeground, ((GridBagLayoutConfig)object).mLabelForeground)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mLabelSuffix, ((GridBagLayoutConfig)object).mLabelSuffix)) {
            return false;
        }
        if (this.mRequiredAlignment != ((GridBagLayoutConfig)object).mRequiredAlignment) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mRequiredText, ((GridBagLayoutConfig)object).mRequiredText);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.mNumberOfColumns;
        n = 31 * n + this.mLabelAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelFont);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelForeground);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mLabelSuffix);
        n = 31 * n + this.mRequiredAlignment;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mRequiredText);
        return n;
    }
}

