/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beansbinding;

import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessorConfig;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.BooleanConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.NumberConverter;
import org.metawidget.swing.widgetprocessor.binding.beansbinding.ReadOnlyToStringConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.ObjectUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private final AutoBinding.UpdateStrategy mUpdateStrategy;
    private final Map<ConvertFromTo<?, ?>, Converter<?, ?>> mConverters = CollectionUtils.newHashMap();
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor;

    public BeansBindingProcessor() {
        this(new BeansBindingProcessorConfig());
    }

    public BeansBindingProcessor(BeansBindingProcessorConfig beansBindingProcessorConfig) {
        this.mUpdateStrategy = beansBindingProcessorConfig.getUpdateStrategy();
        this.registerConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = BeansBindingProcessor.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Byte == null ? (class$java$lang$Byte = BeansBindingProcessor.class$("java.lang.Byte")) : class$java$lang$Byte));
        this.registerConverter(class$java$lang$Short == null ? (class$java$lang$Short = BeansBindingProcessor.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Short == null ? (class$java$lang$Short = BeansBindingProcessor.class$("java.lang.Short")) : class$java$lang$Short));
        this.registerConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = BeansBindingProcessor.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Integer == null ? (class$java$lang$Integer = BeansBindingProcessor.class$("java.lang.Integer")) : class$java$lang$Integer));
        this.registerConverter(class$java$lang$Long == null ? (class$java$lang$Long = BeansBindingProcessor.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Long == null ? (class$java$lang$Long = BeansBindingProcessor.class$("java.lang.Long")) : class$java$lang$Long));
        this.registerConverter(class$java$lang$Float == null ? (class$java$lang$Float = BeansBindingProcessor.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Float == null ? (class$java$lang$Float = BeansBindingProcessor.class$("java.lang.Float")) : class$java$lang$Float));
        this.registerConverter(class$java$lang$Double == null ? (class$java$lang$Double = BeansBindingProcessor.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new NumberConverter(class$java$lang$Double == null ? (class$java$lang$Double = BeansBindingProcessor.class$("java.lang.Double")) : class$java$lang$Double));
        this.registerConverter(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeansBindingProcessor.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, new BooleanConverter());
        if (beansBindingProcessorConfig.getConverters() != null) {
            this.mConverters.putAll(beansBindingProcessorConfig.getConverters());
        }
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding<Object, ?, ? extends Component, ?> binding : state.bindings) {
                binding.unbind();
            }
        }
        swingMetawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor, null);
    }

    @Override
    public JComponent processWidget(JComponent jComponent, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        JComponent jComponent2 = jComponent;
        if (jComponent2 instanceof JScrollPane) {
            jComponent2 = (JComponent)((JScrollPane)jComponent2).getViewport().getView();
        }
        this.typesafeAdd(jComponent2, string, map, swingMetawidget);
        return jComponent;
    }

    public void rebind(Object object, SwingMetawidget swingMetawidget) {
        swingMetawidget.updateToInspectWithoutInvalidate(object);
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding binding : state.bindings) {
                binding.unbind();
                binding.setSourceObject(object);
                binding.bind();
                Binding.SyncFailure syncFailure = binding.refresh();
                if (syncFailure == null) continue;
                throw WidgetProcessorException.newException(syncFailure.getType().toString());
            }
        }
        for (Component component : swingMetawidget.getComponents()) {
            if (!(component instanceof SwingMetawidget)) continue;
            this.rebind(object, (SwingMetawidget)component);
        }
    }

    public void save(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            for (Binding binding : state.bindings) {
                Object object = binding.getSourceObject();
                BeanProperty object2 = (BeanProperty)binding.getSourceProperty();
                if (!object2.isWriteable(object) || binding.getConverter() instanceof ReadOnlyToStringConverter) continue;
                try {
                    Binding.SyncFailure syncFailure = binding.save();
                    if (syncFailure == null) continue;
                    throw WidgetProcessorException.newException(syncFailure.getConversionException());
                }
                catch (ClassCastException classCastException) {
                    throw WidgetProcessorException.newException(new StringBuffer().append("When saving from ").append(((Component)binding.getTargetObject()).getClass().getName()).append(" to ").append(object2).append(" (have you used BeansBindingProcessorConfig.setConverter?)").toString(), classCastException);
                }
            }
        }
        for (Component component : swingMetawidget.getComponents()) {
            if (!(component instanceof SwingMetawidget)) continue;
            this.save((SwingMetawidget)component);
        }
    }

    @Override
    public Object convertFromString(String string, Class<?> clazz) {
        Converter converter = this.getConverter(class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String, clazz);
        if (converter != null) {
            return converter.convertForward((Object)string);
        }
        Converter converter2 = this.getConverter(clazz, class$java$lang$String == null ? (class$java$lang$String = BeansBindingProcessor.class$("java.lang.String")) : class$java$lang$String);
        if (converter2 != null) {
            return converter2.convertReverse((Object)string);
        }
        return string;
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
    }

    private <S, T> void registerConverter(Class<S> clazz, Class<T> clazz2, Converter<S, T> converter) {
        this.mConverters.put(new ConvertFromTo<S, T>(clazz, clazz2), converter);
    }

    private <SS, SV, TS extends Component, TV> void typesafeAdd(TS TS, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        Object object;
        String string2 = swingMetawidget.getValueProperty(TS);
        if (string2 == null) {
            return;
        }
        Object t = swingMetawidget.getToInspect();
        String string3 = PathUtils.parsePath(swingMetawidget.getPath()).getNames().replace('/', '.');
        if ("property".equals(string)) {
            if (string3.length() > 0) {
                string3 = new StringBuffer().append(string3).append('.').toString();
            }
            string3 = new StringBuffer().append(string3).append(map.get("name")).toString();
        }
        BeanProperty beanProperty = BeanProperty.create((String)string3);
        BeanProperty beanProperty2 = BeanProperty.create((String)string2);
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)this.mUpdateStrategy, t, (Property)beanProperty, TS, (Property)beanProperty2);
        Class clazz = beanProperty2.getWriteType(TS);
        Object object2 = null;
        if (beanProperty.isWriteable(t)) {
            object = beanProperty.getWriteType(t);
            object2 = this.getConverter((Class<SV>)object, clazz);
        } else if (beanProperty.isReadable(t)) {
            object = beanProperty.getValue(t);
            if (object != null) {
                Class<?> clazz2 = object.getClass();
                object2 = this.getConverter(clazz2, clazz);
            }
        } else {
            throw WidgetProcessorException.newException(new StringBuffer().append("Property '").append(string3).append("' has no getter and no setter (or parent is null)").toString());
        }
        if (object2 == null && ("true".equals(map.get("read-only")) || "true".equals(map.get("no-setter")))) {
            object2 = new ReadOnlyToStringConverter();
        }
        autoBinding.setConverter(object2);
        try {
            autoBinding.bind();
        }
        catch (ClassCastException classCastException) {
            throw WidgetProcessorException.newException(new StringBuffer().append("When binding ").append(swingMetawidget.getPath()).append('/').append(string3).append(" to ").append(TS.getClass()).append(".").append(string2).append(" (have you used BeansBindingProcessorConfig.setConverter?)").toString(), classCastException);
        }
        object = this.getState(swingMetawidget);
        if (((State)object).bindings == null) {
            ((State)object).bindings = CollectionUtils.newHashSet();
        }
        ((State)object).bindings.add((Binding<Object, ?, Component, ?>)autoBinding);
    }

    private <SV, TV> Converter<SV, TV> getConverter(Class<SV> clazz, Class<TV> clazz2) {
        Class<Object> clazz3 = clazz;
        Class<Object> clazz4 = clazz2;
        if (clazz3.isPrimitive()) {
            clazz3 = ClassUtils.getWrapperClass(clazz3);
        }
        if (clazz4.isPrimitive()) {
            clazz4 = ClassUtils.getWrapperClass(clazz4);
        }
        while (clazz3 != null) {
            Converter<?, ?> converter = this.mConverters.get(new ConvertFromTo<SV, TV>(clazz3, clazz4));
            if (converter != null) {
                return converter;
            }
            clazz3 = clazz3.getSuperclass();
        }
        return null;
    }

    private State getState(SwingMetawidget swingMetawidget) {
        State state = (State)swingMetawidget.getClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor);
        if (state == null) {
            state = new State();
            swingMetawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor = BeansBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beansbinding.BeansBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beansbinding$BeansBindingProcessor, state);
        }
        return state;
    }

    @Override
    public /* synthetic */ void onEndBuild(Object object) {
        this.onEndBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ void onStartBuild(Object object) {
        this.onStartBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ Object processWidget(Object object, String string, Map map, Object object2) {
        return this.processWidget((JComponent)object, string, (Map<String, String>)map, (SwingMetawidget)object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ConvertFromTo<S, T> {
        private Class<S> mSource;
        private Class<T> mTarget;

        public ConvertFromTo(Class<S> clazz, Class<T> clazz2) {
            this.mSource = clazz;
            this.mTarget = clazz2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.mSource, ((ConvertFromTo)object).mSource)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.mTarget, ((ConvertFromTo)object).mTarget);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + ObjectUtils.nullSafeHashCode(new Integer(this.mSource.hashCode()));
            n = 31 * n + ObjectUtils.nullSafeHashCode(new Integer(this.mTarget.hashCode()));
            return n;
        }
    }

    static class State {
        Set<Binding<Object, ?, ? extends Component, ?>> bindings;

        State() {
        }
    }
}

