/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.binding.beanutils;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.swing.widgetprocessor.binding.BindingConverter;
import org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtilsBindingProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget>,
BindingConverter {
    private static final String SCALA_SET_SUFFIX = "_$eq";
    private final int mPropertyStyle;
    static /* synthetic */ Class class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor;

    public BeanUtilsBindingProcessor() {
        this(new BeanUtilsBindingProcessorConfig());
    }

    public BeanUtilsBindingProcessor(BeanUtilsBindingProcessorConfig beanUtilsBindingProcessorConfig) {
        this.mPropertyStyle = beanUtilsBindingProcessorConfig.getPropertyStyle();
    }

    @Override
    public void onStartBuild(SwingMetawidget swingMetawidget) {
        swingMetawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor, null);
    }

    @Override
    public JComponent processWidget(JComponent jComponent, String string, Map<String, String> map, SwingMetawidget swingMetawidget) {
        String string2;
        JComponent jComponent2 = jComponent;
        if (jComponent2 instanceof JScrollPane) {
            jComponent2 = (JComponent)((JScrollPane)jComponent2).getViewport().getView();
        }
        if ((string2 = swingMetawidget.getValueProperty(jComponent2)) == null) {
            return jComponent;
        }
        String string3 = swingMetawidget.getPath();
        if ("property".equals(string)) {
            string3 = new StringBuffer().append(string3).append('/').append(map.get("name")).toString();
        }
        try {
            Object object;
            String string4 = PathUtils.parsePath(string3, '/').getNames().replace('/', '.');
            try {
                object = this.retrieveValueFromObject(swingMetawidget, swingMetawidget.getToInspect(), string4);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw WidgetProcessorException.newException(new StringBuffer().append("Property '").append(string4).append("' has no getter").toString());
            }
            SavedBinding savedBinding = new SavedBinding(jComponent2, string2, string4, "true".equals(map.get("no-setter")));
            this.saveValueToWidget(savedBinding, object);
            State state = this.getState(swingMetawidget);
            if (state.bindings == null) {
                state.bindings = CollectionUtils.newHashSet();
            }
            state.bindings.add(savedBinding);
        }
        catch (Exception exception) {
            throw WidgetProcessorException.newException(exception);
        }
        return jComponent;
    }

    public void rebind(Object object, SwingMetawidget swingMetawidget) {
        swingMetawidget.updateToInspectWithoutInvalidate(object);
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding savedBinding : state.bindings) {
                    Object object2;
                    String object3 = savedBinding.getNames();
                    try {
                        object2 = this.retrieveValueFromObject(swingMetawidget, object, object3);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        throw WidgetProcessorException.newException(new StringBuffer().append("Property '").append(object3).append("' has no getter").toString());
                    }
                    this.saveValueToWidget(savedBinding, object2);
                }
            }
            catch (Exception exception) {
                throw WidgetProcessorException.newException(exception);
            }
        }
        for (Component component : swingMetawidget.getComponents()) {
            if (!(component instanceof SwingMetawidget)) continue;
            this.rebind(object, (SwingMetawidget)component);
        }
    }

    public void save(SwingMetawidget swingMetawidget) {
        State state = this.getState(swingMetawidget);
        if (state.bindings != null) {
            try {
                for (SavedBinding savedBinding : state.bindings) {
                    if (!savedBinding.isSettable()) continue;
                    Object object = this.retrieveValueFromWidget(savedBinding);
                    this.saveValueToObject(swingMetawidget, savedBinding.getNames(), object);
                }
            }
            catch (Exception exception) {
                throw WidgetProcessorException.newException(exception);
            }
        }
        for (Component component : swingMetawidget.getComponents()) {
            if (!(component instanceof SwingMetawidget)) continue;
            this.save((SwingMetawidget)component);
        }
    }

    @Override
    public Object convertFromString(String string, Class<?> clazz) {
        return ConvertUtils.convert((String)string, clazz);
    }

    @Override
    public void onEndBuild(SwingMetawidget swingMetawidget) {
    }

    protected Object retrieveValueFromObject(SwingMetawidget swingMetawidget, Object object, String string) throws Exception {
        switch (this.mPropertyStyle) {
            case 1: {
                return this.scalaTraverse(object, false, string.split("\\."));
            }
        }
        return PropertyUtils.getProperty((Object)object, (String)string);
    }

    protected void saveValueToObject(SwingMetawidget swingMetawidget, String string, Object object) throws Exception {
        Object t = swingMetawidget.getToInspect();
        switch (this.mPropertyStyle) {
            case 1: {
                String[] stringArray = string.split("\\.");
                Object object2 = this.scalaTraverse(t, true, stringArray);
                if (object2 == null) {
                    return;
                }
                Class<?> clazz = object2.getClass();
                String string2 = stringArray[stringArray.length - 1];
                Class<?> clazz2 = clazz.getMethod(string2, new Class[0]).getReturnType();
                Object object3 = ConvertUtils.convert((Object)object, clazz2);
                Method method = clazz.getMethod(new StringBuffer().append(string2).append(SCALA_SET_SUFFIX).toString(), clazz2);
                method.invoke(object2, object3);
                break;
            }
            default: {
                BeanUtils.setProperty(t, (String)string, (Object)object);
            }
        }
    }

    protected Object retrieveValueFromWidget(SavedBinding savedBinding) throws Exception {
        return PropertyUtils.getProperty((Object)savedBinding.getComponent(), (String)savedBinding.getComponentProperty());
    }

    protected void saveValueToWidget(SavedBinding savedBinding, Object object) throws Exception {
        BeanUtils.setProperty((Object)savedBinding.getComponent(), (String)savedBinding.getComponentProperty(), (Object)object);
    }

    private Object scalaTraverse(Object object, boolean bl, String[] stringArray) throws Exception {
        Method method;
        if (object == null) {
            return null;
        }
        if (stringArray == null) {
            return object;
        }
        int n = stringArray.length;
        if (n == 0) {
            return object;
        }
        if (bl) {
            --n;
        }
        Object object2 = object;
        for (int i = 0; i < n && (object2 = (method = object2.getClass().getMethod(stringArray[i], new Class[0])).invoke(object2, new Object[0])) != null; ++i) {
        }
        return object2;
    }

    private State getState(SwingMetawidget swingMetawidget) {
        State state = (State)swingMetawidget.getClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor);
        if (state == null) {
            state = new State();
            swingMetawidget.putClientProperty(class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor == null ? (class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor = BeanUtilsBindingProcessor.class$("org.metawidget.swing.widgetprocessor.binding.beanutils.BeanUtilsBindingProcessor")) : class$org$metawidget$swing$widgetprocessor$binding$beanutils$BeanUtilsBindingProcessor, state);
        }
        return state;
    }

    @Override
    public /* synthetic */ void onEndBuild(Object object) {
        this.onEndBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ void onStartBuild(Object object) {
        this.onStartBuild((SwingMetawidget)object);
    }

    @Override
    public /* synthetic */ Object processWidget(Object object, String string, Map map, Object object2) {
        return this.processWidget((JComponent)object, string, (Map<String, String>)map, (SwingMetawidget)object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    class SavedBinding {
        private Component mComponent;
        private String mComponentProperty;
        private String mNames;
        private boolean mNoSetter;

        public SavedBinding(Component component, String string, String string2, boolean bl) {
            this.mComponent = component;
            this.mComponentProperty = string;
            this.mNames = string2;
            this.mNoSetter = bl;
        }

        public Component getComponent() {
            return this.mComponent;
        }

        public String getComponentProperty() {
            return this.mComponentProperty;
        }

        public String getNames() {
            return this.mNames;
        }

        public boolean isSettable() {
            return !this.mNoSetter;
        }
    }

    static class State {
        Set<SavedBinding> bindings;

        State() {
        }
    }
}

