/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.regex.Pattern;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    public static final String JAVABEAN_SET_PREFIX = "set";
    public static final String JAVABEAN_GET_PREFIX = "get";
    public static final String JAVABEAN_IS_PREFIX = "is";
    public static final Class<?>[] NO_CLASSES = new Class[0];
    private static final Pattern PROXY_PATTERN = Pattern.compile("ByCGLIB\\$\\$|_\\$\\$_javassist_");
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$metawidget$util$ClassUtils;

    public static Method getReadMethod(Class clazz, String string) {
        String string2 = StringUtils.uppercaseFirstLetter(string);
        try {
            return clazz.getMethod(new StringBuffer().append(JAVABEAN_GET_PREFIX).append(string2).toString(), new Class[0]);
        }
        catch (Exception exception) {
            try {
                return clazz.getMethod(new StringBuffer().append(JAVABEAN_IS_PREFIX).append(string2).toString(), new Class[0]);
            }
            catch (Exception exception2) {
                throw new RuntimeException(new StringBuffer().append("No such method get").append(string2).append("() or ").append(JAVABEAN_IS_PREFIX).append(string2).append("() on ").append(clazz).toString(), exception);
            }
        }
    }

    public static Method getWriteMethod(Class clazz, String string, Class clazz2) {
        String string2 = StringUtils.uppercaseFirstLetter(string);
        for (Class clazz3 = clazz2; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                return clazz.getMethod(new StringBuffer().append(JAVABEAN_SET_PREFIX).append(string2).toString(), clazz3);
            }
            catch (Throwable throwable) {
                continue;
            }
        }
        for (Class<?> clazz4 : clazz2.getInterfaces()) {
            try {
                return clazz.getMethod(new StringBuffer().append(JAVABEAN_SET_PREFIX).append(string2).toString(), clazz4);
            }
            catch (Throwable throwable) {
            }
        }
        throw new RuntimeException(new StringBuffer().append("No such method set").append(string2).append("( ").append(clazz2.getName()).append(" ) on ").append(clazz).toString());
    }

    public static <T> T getProperty(Object object, String string) {
        try {
            Method method = ClassUtils.getReadMethod(object.getClass(), string);
            return (T)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuffer().append("Unable to get '").append(string).append("' of '").append(object).append("'").toString(), exception);
        }
    }

    public static void setProperty(Object object, String string, Object object2) {
        try {
            Class<?> clazz = object.getClass();
            Method method = ClassUtils.getReadMethod(clazz, string);
            method = ClassUtils.getWriteMethod(clazz, string, method.getReturnType());
            method.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuffer().append("Unable to set '").append(string).append("' of '").append(object).append("' to '").append(object2).append("'").toString(), exception);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if ((class$java$lang$Number == null ? (class$java$lang$Number = ClassUtils.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz)) {
            return true;
        }
        return (class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (clazz.equals(Byte.TYPE)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz.equals(Short.TYPE)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (clazz.equals(Integer.TYPE)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz.equals(Long.TYPE)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz.equals(Float.TYPE)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz.equals(Double.TYPE)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz.equals(Character.TYPE)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        throw new RuntimeException(new StringBuffer().append(clazz).append(" is not a primitive type").toString());
    }

    public static boolean classExists(String string) {
        try {
            Class.forName(string, false, null);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static Class<?> getUnproxiedClass(Class<?> clazz) {
        return ClassUtils.getUnproxiedClass(clazz, PROXY_PATTERN);
    }

    public static Class<?> getUnproxiedClass(Class<?> clazz, Pattern pattern) {
        Class<?> clazz2;
        if (pattern == null || !pattern.matcher(clazz.getName()).find()) {
            return clazz;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = ClassUtils.class$("java.lang.Object")) : class$java$lang$Object).equals(clazz2 = clazz.getSuperclass())) {
            return clazz;
        }
        return clazz2;
    }

    public static Class<?> niceForName(String string) {
        return ClassUtils.niceForName(string, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> niceForName(String string, ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return Class.forName(string, false, classLoader);
            }
            return Class.forName(string, false, (class$org$metawidget$util$ClassUtils == null ? (class$org$metawidget$util$ClassUtils = ClassUtils.class$("org.metawidget.util.ClassUtils")) : class$org$metawidget$util$ClassUtils).getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            return null;
        }
    }

    public static String getSimpleName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static InputStream openResource(String string) throws FileNotFoundException {
        InputStream inputStream;
        if (string == null || "".equals(string.trim())) {
            throw new FileNotFoundException("No resource specified");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        inputStream = (class$org$metawidget$util$ClassUtils == null ? (class$org$metawidget$util$ClassUtils = ClassUtils.class$("org.metawidget.util.ClassUtils")) : class$org$metawidget$util$ClassUtils).getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(new StringBuffer().append("Unable to locate ").append(string).append(" on CLASSPATH").toString());
    }

    private ClassUtils() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

